/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container.slot;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class ScrollableSlot
extends ResourceHandlerSlot {
    private int actualSlotIndex;
    private boolean active = true;
    private final ResourceHandler<ItemResource> handler;
    private final IndexModifier<ItemResource> slotModifier;

    public ScrollableSlot(ResourceHandler<ItemResource> handler, IndexModifier<ItemResource> slotModifier, int index, int xPosition, int yPosition) {
        super(handler, slotModifier, index, xPosition, yPosition);
        this.actualSlotIndex = index;
        this.handler = handler;
        this.slotModifier = slotModifier;
    }

    public void setSlotIndex(int slot) {
        this.actualSlotIndex = slot;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.handler.isValid(this.actualSlotIndex, (Resource)ItemResource.of((ItemStack)stack));
    }

    public ItemStack getStackCopy() {
        return ((ItemResource)this.handler.getResource(this.actualSlotIndex)).toStack(this.handler.getAmountAsInt(this.actualSlotIndex));
    }

    public void setStackCopy(@NotNull ItemStack stack) {
        this.slotModifier.set(this.actualSlotIndex, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
    }

    public int getMaxStackSize() {
        return this.handler.getCapacityAsInt(this.actualSlotIndex, (Resource)ItemResource.EMPTY);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return this.handler.getCapacityAsInt(this.actualSlotIndex, (Resource)ItemResource.of((ItemStack)stack));
    }

    public boolean mayPickup(Player playerIn) {
        try (Transaction tx = Transaction.open(null);){
            boolean bl = this.handler.extract(this.actualSlotIndex, (Resource)((ItemResource)this.handler.getResource(this.actualSlotIndex)), 1, (TransactionContext)tx) == 1;
            return bl;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

