/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container.slot.backpack;

import dev.willyelton.crystal_tools.common.inventory.CompressionItemStackHandler;
import dev.willyelton.crystal_tools.common.inventory.container.slot.CrystalSlotItemHandler;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.CompressionOutputSlot;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;

public class CompressionInputSlot
extends CrystalSlotItemHandler {
    private final CompressionOutputSlot outputSlot;
    private final Level level;
    private final CompressionItemStackHandler compressionHandler;

    public CompressionInputSlot(CompressionItemStackHandler itemHandler, IndexModifier<ItemResource> indexModifier, int index, int x, int y, CompressionOutputSlot outputSlot, Level level) {
        super((ResourceHandler<ItemResource>)itemHandler, indexModifier, index, x, y);
        this.outputSlot = outputSlot;
        this.level = level;
        this.compressionHandler = itemHandler;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public boolean mayPickup(Player playerIn) {
        return false;
    }

    public void onClicked(ItemStack stack) {
        Optional<RecipeHolder<CraftingRecipe>> threeOptional = this.getRecipe(stack, 3);
        Optional<RecipeHolder<CraftingRecipe>> twoOptional = this.getRecipe(stack, 2);
        CompressionItemStackHandler.CompressionMode compressionMode = this.compressionHandler.getMode(this.getIndex());
        if (stack.is(this.getItem().getItem())) {
            if (compressionMode == CompressionItemStackHandler.CompressionMode.THREE_BY_THREE && twoOptional.isPresent()) {
                this.setSlots(stack, twoOptional.get(), 2);
                this.compressionHandler.setMode(CompressionItemStackHandler.CompressionMode.TWO_BY_TWO, this.getIndex());
                return;
            }
            if (compressionMode == CompressionItemStackHandler.CompressionMode.TWO_BY_TWO && threeOptional.isPresent()) {
                this.setSlots(stack, threeOptional.get(), 3);
                this.compressionHandler.setMode(CompressionItemStackHandler.CompressionMode.THREE_BY_THREE, this.getIndex());
                return;
            }
        }
        if (threeOptional.isPresent()) {
            this.setSlots(stack, threeOptional.get(), 3);
            this.compressionHandler.setMode(CompressionItemStackHandler.CompressionMode.THREE_BY_THREE, this.getIndex());
        } else if (twoOptional.isPresent()) {
            this.setSlots(stack, twoOptional.get(), 2);
            this.compressionHandler.setMode(CompressionItemStackHandler.CompressionMode.TWO_BY_TWO, this.getIndex());
        } else {
            this.set(ItemStack.EMPTY);
            this.setChanged();
            this.outputSlot.set(ItemStack.EMPTY);
            this.outputSlot.setChanged();
        }
    }

    private CraftingInput getCraftingInput(ItemStack stack, int size) {
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < size * size; ++i) {
            inputStacks.add(stack.copy());
        }
        return CraftingInput.of((int)size, (int)size, inputStacks);
    }

    private Optional<RecipeHolder<CraftingRecipe>> getRecipe(ItemStack stack, int size) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        CraftingInput craftingInput = this.getCraftingInput(stack, size);
        RecipeAccess recipeAccess = this.level.recipeAccess();
        if (recipeAccess instanceof RecipeManager) {
            RecipeManager recipeManager = (RecipeManager)recipeAccess;
            return recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, this.level);
        }
        return Optional.empty();
    }

    private void setSlots(ItemStack stack, RecipeHolder<CraftingRecipe> recipe, int size) {
        CraftingRecipe actualRecipe = (CraftingRecipe)recipe.value();
        ItemStack inputStack = stack.copy();
        inputStack.setCount(1);
        this.set(inputStack);
        this.setChanged();
        ItemStack outputStack = actualRecipe.assemble((RecipeInput)this.getCraftingInput(stack, size), (HolderLookup.Provider)this.level.registryAccess()).copy();
        this.outputSlot.set(outputStack);
        this.outputSlot.setChanged();
    }
}

