/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory.container.subscreen;

import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.backpack.BackpackFilterSlot;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.utils.TransferUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class FilterMenuContents<T extends BaseContainerMenu> {
    private final T menu;
    @Nullable
    private final ResourceHandler<ItemResource> filterInventory;
    private final NonNullList<BackpackFilterSlot> filterSlots;
    private boolean whitelist;

    public FilterMenuContents(T menu, int filterSlots, boolean whiteList) {
        this.menu = menu;
        this.filterInventory = filterSlots > 0 ? ((FilterContainerMenu)menu).getFilterInventory() : null;
        this.filterSlots = NonNullList.createWithCapacity((int)(filterSlots * 9));
        this.whitelist = whiteList;
    }

    public boolean getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public int getSlotCount() {
        if (this.filterInventory != null) {
            return this.filterInventory.size();
        }
        return 0;
    }

    public NonNullList<BackpackFilterSlot> getFilterSlots() {
        return this.filterSlots;
    }

    public ResourceHandler<ItemResource> getInventory() {
        return this.filterInventory;
    }

    public void addSlot(BackpackFilterSlot slot) {
        this.filterSlots.add((Object)slot);
    }

    public ItemStack quickMove(ItemStack stack) {
        if (!stack.isEmpty()) {
            for (BackpackFilterSlot filterSlot : this.filterSlots) {
                if (!filterSlot.getItem().isEmpty()) continue;
                filterSlot.onClicked(stack);
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public void toggleSlots(boolean enabled) {
        this.filterSlots.forEach(filterSlot -> filterSlot.setActive(enabled));
    }

    public void clear() {
        if (this.filterInventory != null) {
            TransferUtils.clear(this.filterInventory);
        }
    }

    public void matchContents(ResourceHandler<ItemResource> handler, boolean shiftDown) {
        if (this.filterInventory == null) {
            return;
        }
        if (shiftDown) {
            TransferUtils.clear(this.filterInventory);
        }
        int filterIndex = 0;
        for (int i = 0; i < handler.size() && filterIndex < this.getSlotCount(); ++i) {
            ItemResource resource = (ItemResource)handler.getResource(i);
            if (resource.isEmpty() || ResourceHandlerUtil.contains(this.filterInventory, (Resource)resource)) continue;
            try (Transaction tx = Transaction.open(null);){
                this.filterInventory.insert((Resource)resource, 1, (TransactionContext)tx);
                tx.commit();
                continue;
            }
        }
    }
}

