/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.compat.curios.CuriosCompatibility;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.CrystalBackpackInventory;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalBackpackContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CrystalBackpack
extends Item
implements LevelableItem {
    public CrystalBackpack(Item.Properties properties) {
        super(properties.stacksTo(1).fireResistant());
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
        return InteractionResult.SUCCESS;
    }

    public void openBackpack(ServerPlayer serverPlayer, ItemStack backpackStack, int slotIndex) {
        serverPlayer.openMenu((MenuProvider)new CrystalBackpackMenuSupplier(this, backpackStack, slotIndex), friendlyByteBuf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(friendlyByteBuf, (Object)backpackStack);
            friendlyByteBuf.writeInt(slotIndex);
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        ItemStack backpackStack = context.getItemInHand();
        if (((Boolean)backpackStack.getOrDefault(DataComponents.INVENTORY_STORE, (Object)false)).booleanValue()) {
            CrystalBackpackInventory backpackInventory = CrystalBackpack.getInventory(backpackStack);
            if (blockEntity != null && backpackInventory != null) {
                ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, context.getClickedPos(), (Object)context.getClickedFace());
                if (handler != null) {
                    for (int i = 0; i < backpackInventory.size(); ++i) {
                        ItemResource resource = (ItemResource)backpackInventory.getResource(i);
                        if (resource.isEmpty()) continue;
                        try (Transaction tx = Transaction.open(null);){
                            int amountExtracted = backpackInventory.extract(i, (Resource)resource, 64, (TransactionContext)tx);
                            int leftOver = amountExtracted - handler.insert((Resource)resource, amountExtracted, (TransactionContext)tx);
                            if (leftOver > 0) {
                                backpackInventory.insert(i, (Resource)resource, leftOver, (TransactionContext)tx);
                            }
                            tx.commit();
                            continue;
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public int getMaxDamage(ItemStack itemStack) {
        return 1;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> components, TooltipFlag flag) {
        components.accept((Component)Component.literal((String)"Crystal Backpack is currently broken and waiting on a Neoforge update").withStyle(ChatFormatting.RED));
        if (((Boolean)itemStack.getOrDefault(DataComponents.BACKPACK_AUTO_PICKUP, (Object)false)).booleanValue()) {
            String toolTip = "\u00a79Auto Pickup " + ((Boolean)itemStack.getOrDefault(DataComponents.PICKUP_DISABLED, (Object)false) != false ? "Disabled" : "Enabled");
            components.accept((Component)Component.literal((String)toolTip));
        }
    }

    public boolean overrideStackedOnOther(ItemStack backpackStack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrystalBackpackInventory inventory = CrystalBackpack.getInventory(backpackStack);
        ItemStack toInsert = slot.getItem();
        if (toInsert.isEmpty()) {
            int lastSlotIndex = inventory.getLastStack();
            if (lastSlotIndex != -1) {
                ItemResource resource = (ItemResource)inventory.getResource(lastSlotIndex);
                if (!resource.isEmpty()) {
                    try (Transaction tx = Transaction.open(null);){
                        int extracted = inventory.extract(lastSlotIndex, (Resource)resource, 64, (TransactionContext)tx);
                        ItemStack toGiveToPlayer = resource.toStack(extracted);
                        ItemStack leftOver = slot.safeInsert(toGiveToPlayer);
                        inventory.insert(lastSlotIndex, (Resource)resource, leftOver.getCount(), (TransactionContext)tx);
                        this.playRemoveOneSound((Entity)player);
                        tx.commit();
                    }
                }
                return true;
            }
        } else if (toInsert.getItem().canFitInsideContainerItems()) {
            ItemStack result = inventory.insertStack(toInsert);
            slot.set(result);
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack backpackStack, ItemStack toInsert, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        CrystalBackpackInventory inventory = CrystalBackpack.getInventory(backpackStack);
        if (toInsert.isEmpty()) {
            int lastSlotIndex = inventory.getLastStack();
            if (lastSlotIndex != -1) {
                ItemResource resource = (ItemResource)inventory.getResource(lastSlotIndex);
                if (!resource.isEmpty()) {
                    try (Transaction tx = Transaction.open(null);){
                        int extracted = inventory.extract(lastSlotIndex, (Resource)resource, 64, (TransactionContext)tx);
                        ItemStack toGiveToPlayer = resource.toStack(extracted);
                        access.set(toGiveToPlayer);
                        this.playRemoveOneSound((Entity)player);
                        tx.commit();
                    }
                }
                return true;
            }
        } else {
            ItemStack result = inventory.insertStack(toInsert.copy());
            toInsert.setCount(result.getCount());
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static List<ItemStack> findBackpackStacks(Player player) {
        return InventoryUtils.findAll(player, stack -> stack.is((Item)ModRegistration.CRYSTAL_BACKPACK.get()));
    }

    public static int findNextBackpackSlot(Player player) {
        List<ItemStack> curiosStacks = CuriosCompatibility.getCrystalBackpacksInCurios(player);
        if (!curiosStacks.isEmpty()) {
            return -2;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).is((Item)ModRegistration.CRYSTAL_BACKPACK.get())) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getBackpackFromSlotIndex(Player player, int slotIndex) {
        if (slotIndex == -1) {
            return ItemStack.EMPTY;
        }
        if (slotIndex == -2) {
            List<ItemStack> curiosStacks = CuriosCompatibility.getCrystalBackpacksInCurios(player);
            if (curiosStacks.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return curiosStacks.get(0);
        }
        return player.getInventory().getItem(slotIndex);
    }

    public static CrystalBackpackInventory getInventory(ItemStack stack) {
        ResourceHandler handler = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Item.ITEM);
        if (handler == null) {
            CrystalTools.LOGGER.error("Crystal Backpack cannot find capability");
            return new CrystalBackpackInventory(0);
        }
        if (handler instanceof CrystalBackpackInventory) {
            CrystalBackpackInventory crystalBackpackInventory = (CrystalBackpackInventory)handler;
            return crystalBackpackInventory;
        }
        CrystalTools.LOGGER.error("Different inventory capability found on crystal backpack");
        return new CrystalBackpackInventory(0);
    }

    public static void addXpToBackpacks(Player player, int exp) {
        CrystalBackpack.findBackpackStacks(player).forEach(stack -> {
            Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)player.level().registryAccess());
            if (levelable != null) {
                levelable.addExp(player.level(), player.blockPosition(), (LivingEntity)player, exp);
            }
        });
    }

    private record CrystalBackpackMenuSupplier(CrystalBackpack backpackItem, ItemStack stack, int slotIndex) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }

        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new CrystalBackpackContainerMenu(containerId, playerInventory, this.stack, this.slotIndex);
        }
    }
}

