/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface EntityTargeter {
    default public void refreshTarget(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!this.isEnabled(stack)) {
            return;
        }
        int targetId = (Integer)stack.getOrDefault(DataComponents.ENTITY_TARGET, (Object)-1);
        if (targetId != -1 && level.getGameTime() % 5L != 0L) {
            return;
        }
        LivingEntity newTarget = this.findNewTarget(livingEntity);
        if (targetId == -1) {
            this.setTarget(stack, newTarget);
        } else if (newTarget != null && !newTarget.isRemoved()) {
            this.clearTarget(stack, level);
            this.setTarget(stack, newTarget);
        }
    }

    @Nullable
    default public LivingEntity findNewTarget(LivingEntity user) {
        LivingEntity target;
        Entity entity;
        Vec3 vec3 = user.getEyePosition();
        Vec3 vec31 = user.getViewVector(1.0f);
        Vec3 vec32 = vec3.add(vec31.x * 100.0, vec31.y * 100.0, vec31.z * 100.0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Level)user.level(), (Entity)user, (Vec3)vec3, (Vec3)vec32, (AABB)new AABB(vec3, vec32).inflate(1.0), e -> !e.isSpectator(), (float)0.0f);
        if (entityhitresult != null && (entity = entityhitresult.getEntity()) instanceof LivingEntity && user.hasLineOfSight((Entity)(target = (LivingEntity)entity))) {
            return target;
        }
        return null;
    }

    default public void setTarget(ItemStack stack, LivingEntity target) {
        if (!this.isEnabled(stack)) {
            return;
        }
        if (target != null && !target.isRemoved()) {
            stack.set(DataComponents.ENTITY_TARGET, (Object)target.getId());
            target.setGlowingTag(true);
        }
    }

    default public void clearTarget(ItemStack stack, Level level) {
        Entity levelEntity;
        if (!this.isEnabled(stack)) {
            return;
        }
        int target = (Integer)stack.getOrDefault(DataComponents.ENTITY_TARGET, (Object)-1);
        if (target != -1 && (levelEntity = level.getEntity(target)) != null && !levelEntity.isRemoved()) {
            levelEntity.setGlowingTag(false);
            stack.remove(DataComponents.ENTITY_TARGET);
        }
    }

    default public boolean isEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponents.DISABLE_AUTO_TARGET, (Object)false) == false && (Boolean)stack.getOrDefault(DataComponents.AUTO_TARGET, (Object)false) != false;
    }
}

