/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface LevelableItem {
    public static final ToolMaterial CRYSTAL = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2031, 9.0f, 4.0f, 15, CrystalToolsTags.REPAIRS_CRYSTAL);

    @Deprecated
    default public int getExperienceCap(ItemStack tool) {
        return (Integer)tool.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)((Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get()));
    }

    default public void levelableInventoryTick(ItemStack stack, Level level, Entity entity, @Nullable EquipmentSlot equipmentSlot, double repairModifier) {
        if ((equipmentSlot == null || ((Boolean)CrystalToolsConfig.REPAIR_IN_HAND.get()).booleanValue()) && (Integer)stack.getOrDefault(DataComponents.AUTO_REPAIR, (Object)0) > 0) {
            long gameTimeToRepair = (Long)stack.getOrDefault(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)-1L);
            if (gameTimeToRepair == -1L) {
                stack.set(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)(level.getGameTime() + (long)((double)((Integer)CrystalToolsConfig.TOOL_REPAIR_COOLDOWN.get()).intValue() * repairModifier)));
            } else if (gameTimeToRepair <= level.getGameTime()) {
                stack.set(DataComponents.AUTO_REPAIR_GAME_TIME, (Object)(level.getGameTime() + (long)((double)((Integer)CrystalToolsConfig.TOOL_REPAIR_COOLDOWN.get()).intValue() * repairModifier)));
                int repairAmount = Math.min((Integer)stack.getOrDefault(DataComponents.AUTO_REPAIR, (Object)0), stack.getDamageValue());
                stack.setDamageValue(stack.getDamageValue() - repairAmount);
            }
        }
    }
}

