/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import com.google.common.base.Predicates;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.compat.curios.CuriosCompatibility;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import dev.willyelton.crystal_tools.common.inventory.PortableGeneratorInventory;
import dev.willyelton.crystal_tools.common.inventory.container.PortableGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalGeneratorBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ILevelableContainerData;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ItemStackLevelableContainerData;
import dev.willyelton.crystal_tools.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class PortableGenerator
extends Item
implements LevelableItem {
    public PortableGenerator(Item.Properties properties) {
        super(properties.stacksTo(1).fireResistant());
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        EnergyHandler handler = (EnergyHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Energy.ITEM);
        if (handler != null && handler.getAmountAsInt() > 0) {
            return Math.round(13.0f - 13.0f * this.getFillLevel(stack));
        }
        return 0;
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(0.5f + this.getFillLevel(stack) / 2.0f), (float)1.0f, (float)1.0f);
    }

    private float getFillLevel(ItemStack stack) {
        EnergyHandler handler = (EnergyHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Energy.ITEM);
        if (handler != null && handler.getAmountAsInt() > 0) {
            return (float)(handler.getCapacityAsInt() - handler.getAmountAsInt()) / (float)handler.getCapacityAsInt();
        }
        return 0.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.literal((String)"Portable Generator is currently broken and waiting on a Neoforge update").withStyle(ChatFormatting.RED));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.literal((String)String.format("\u00a7b%s FE / %s FE", StringUtils.intToCompactString(PortableGenerator.getEnergy(stack)), StringUtils.intToCompactString(PortableGenerator.getCapacity(stack)))));
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        PortableGenerator.tick(stack, (Level)level, List.of(entity), entity.getOnPos(), () -> PortableGenerator.getNextFuelStack(stack, (Level)level), true);
    }

    public static ItemStack getNextFuelStack(ItemStack stack, Level level) {
        PortableGeneratorInventory inventory = PortableGenerator.getInventory(stack, level);
        if (inventory != null) {
            return inventory.nextItem();
        }
        return ItemStack.EMPTY;
    }

    public static void tick(ItemStack stack, Level level, List<Entity> entities, BlockPos pos, Supplier<ItemStack> fuelSupplier, boolean levelItems) {
        ItemStack toBurn;
        GeneratorFuelData fuelData;
        Player player = null;
        if (level.getGameTime() % 20L == 4L) {
            ArrayList<ItemStack> curiosStacks = new ArrayList<ItemStack>();
            ArrayList<ResourceHandler<ItemResource>> handlers = new ArrayList<ResourceHandler<ItemResource>>();
            for (Entity entity : entities) {
                Player p;
                ResourceHandler handler = (ResourceHandler)entity.getCapability(Capabilities.Item.ENTITY);
                if (handler != null) {
                    handlers.add(handler);
                }
                if (!(entity instanceof Player)) continue;
                player = p = (Player)entity;
                curiosStacks.addAll(CuriosCompatibility.getItemInCurios(player, (Predicate<ItemStack>)Predicates.alwaysTrue()));
            }
            int leftOverEnergy = PortableGenerator.distributeEnergyToStacks((Integer)stack.getOrDefault(DataComponents.FE_STORED, (Object)0), curiosStacks);
            if (leftOverEnergy > 0) {
                leftOverEnergy = PortableGenerator.distributeEnergy(leftOverEnergy, handlers);
            }
            stack.set(DataComponents.FE_STORED, (Object)leftOverEnergy);
        }
        if ((fuelData = (GeneratorFuelData)stack.get(DataComponents.BURNING_ITEM_DATA)) == null && !(toBurn = fuelSupplier.get()).isEmpty()) {
            int burnTime;
            GeneratorFuelData newFuelData = CrystalGeneratorBlockEntity.getFuelData(toBurn, (Boolean)stack.getOrDefault(DataComponents.FOOD_GENERATOR, (Object)false), (Boolean)stack.getOrDefault(DataComponents.METAL_GENERATOR, (Object)false), (Boolean)stack.getOrDefault(DataComponents.GEM_GENERATOR, (Object)false));
            if (newFuelData == null && (burnTime = toBurn.getBurnTime(null, level.fuelValues())) > 0) {
                newFuelData = new GeneratorFuelData(burnTime, 0);
            }
            if (newFuelData != null) {
                newFuelData = new GeneratorFuelData((int)Math.ceil((float)newFuelData.burnTime() * (1.0f + ((Float)stack.getOrDefault((DataComponentType)DataComponents.FUEL_EFFICIENCY.get(), (Object)Float.valueOf(0.0f))).floatValue())), newFuelData.bonusGeneration());
                stack.set(DataComponents.BURNING_ITEM_DATA, (Object)newFuelData);
                stack.set(DataComponents.MAX_BURN_TIME, (Object)newFuelData.burnTime());
                fuelData = newFuelData;
                Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
                if (levelable != null && levelItems) {
                    levelable.addExp(level, pos, (LivingEntity)player, (float)Math.ceil((Double)CrystalToolsConfig.PORTABLE_GENERATOR_SKILL_POINTS_PER_BURN_TIME.get() * (double)newFuelData.burnTime()));
                }
            }
        }
        int energy = PortableGenerator.getEnergy(stack);
        int capacity = PortableGenerator.getCapacity(stack);
        if (fuelData != null) {
            int toGain = PortableGenerator.getGeneration(stack, fuelData);
            if (capacity - energy < toGain) {
                return;
            }
            stack.set(DataComponents.GENERATED_LAST_TICK, (Object)toGain);
            stack.set(DataComponents.FE_STORED, (Object)(energy + toGain));
            GeneratorFuelData newFuelData = new GeneratorFuelData(fuelData.burnTime() - 1, fuelData.bonusGeneration());
            if (newFuelData.burnTime() > 0) {
                stack.set(DataComponents.BURNING_ITEM_DATA, (Object)newFuelData);
            } else {
                stack.remove(DataComponents.BURNING_ITEM_DATA);
            }
        } else {
            stack.remove(DataComponents.GENERATED_LAST_TICK);
        }
    }

    private static int distributeEnergyToStacks(int energy, List<ItemStack> itemsToCharge) {
        for (ItemStack stack : itemsToCharge) {
            if (stack.isEmpty()) continue;
            if (energy <= 0) {
                return energy;
            }
            EnergyHandler handler = (EnergyHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Energy.ITEM);
            if (handler == null) continue;
            Transaction tx = Transaction.open(null);
            try {
                energy -= handler.insert(energy, (TransactionContext)tx);
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        return energy;
    }

    private static int distributeEnergy(int energy, List<ResourceHandler<ItemResource>> handlers) {
        for (ResourceHandler<ItemResource> handler : handlers) {
            for (int i = 0; i < handler.size(); ++i) {
                if (energy <= 0) {
                    return energy;
                }
                ItemAccess itemAccess = ItemAccess.forHandlerIndexStrict(handler, (int)i);
                EnergyHandler energyHandler = (EnergyHandler)itemAccess.getCapability(Capabilities.Energy.ITEM);
                if (energyHandler == null) continue;
                try (Transaction tx = Transaction.open(null);){
                    energy -= energyHandler.insert(energy, (TransactionContext)tx);
                    tx.commit();
                    continue;
                }
            }
        }
        return energy;
    }

    public static PortableGeneratorInventory getInventory(ItemStack stack, Level level) {
        ResourceHandler handler = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Item.ITEM);
        if (handler == null) {
            return new PortableGeneratorInventory(0);
        }
        if (handler instanceof PortableGeneratorInventory) {
            PortableGeneratorInventory portableGeneratorInventory = (PortableGeneratorInventory)handler;
            portableGeneratorInventory.setLevel(level);
            return portableGeneratorInventory;
        }
        return new PortableGeneratorInventory(0);
    }

    public static int getCapacity(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.FE_CAPACITY, (Object)0) * (Integer)CrystalToolsConfig.PORTABLE_GENERATOR_FE_STORAGE_PER_LEVEL.get() + (Integer)CrystalToolsConfig.PORTABLE_GENERATOR_BASE_FE_STORAGE.get();
    }

    public static int getEnergy(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.FE_STORED, (Object)0);
    }

    public static int getGeneration(ItemStack stack, GeneratorFuelData fuelData) {
        if (fuelData == null) {
            return 0;
        }
        return fuelData.bonusGeneration() + (Integer)CrystalToolsConfig.PORTABLE_GENERATOR_BASE_FE_GENERATION.get() + (Integer)stack.getOrDefault(DataComponents.FE_GENERATION, (Object)0) * (Integer)CrystalToolsConfig.PORTABLE_GENERATOR_FE_GENERATION_PER_LEVEL.get();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && oldStack.is(newStack.getItem());
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !oldStack.is(newStack.getItem());
    }

    private record PortableGeneratorMenuSupplier(PortableGenerator generatorItem, ItemStack stack) implements MenuProvider
    {
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }

        public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
            return new PortableGeneratorContainerMenu(containerId, playerInventory, this.createDataAccess(this.stack), this.stack);
        }

        private ILevelableContainerData createDataAccess(final ItemStack stack) {
            return new ItemStackLevelableContainerData(this, stack){

                @Override
                protected int getExtra(int index) {
                    return switch (index) {
                        case 3 -> ((GeneratorFuelData)stack.getOrDefault(DataComponents.BURNING_ITEM_DATA, (Object)new GeneratorFuelData(0, 0))).burnTime();
                        case 4 -> (Integer)stack.getOrDefault(DataComponents.MAX_BURN_TIME, (Object)0);
                        case 5 -> PortableGenerator.getEnergy(stack);
                        case 6 -> PortableGenerator.getCapacity(stack);
                        case 7 -> (Integer)stack.getOrDefault(DataComponents.GENERATED_LAST_TICK, (Object)0);
                        default -> 0;
                    };
                }

                @Override
                protected void setExtra(int index, int value) {
                }

                @Override
                protected int getExtraDataSize() {
                    return 5;
                }
            };
        }
    }
}

