/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.armor;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.armor.CrystalToolsArmorMaterials;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class LevelableArmor
extends Item
implements LevelableItem {
    private static final ArmorMaterial ARMOR_MATERIAL = CrystalToolsArmorMaterials.CRYSTAL;

    public LevelableArmor(Item.Properties properties, ArmorType type) {
        super(properties.fireResistant().durability(CRYSTAL.durability()).repairable(CrystalToolsTags.REPAIRS_CRYSTAL).humanoidArmor(ARMOR_MATERIAL, type));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        String modeSwitchKey = RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString();
        if (((Boolean)stack.getOrDefault(DataComponents.NIGHT_VISION, (Object)false)).booleanValue()) {
            if (((Boolean)stack.getOrDefault(DataComponents.DISABLE_NIGHT_VISION, (Object)false)).booleanValue()) {
                consumer.accept((Component)Component.literal((String)("\u00a7c\u00a7lNight Vision Disabled (" + modeSwitchKey + ") To Enable")));
            } else {
                consumer.accept((Component)Component.literal((String)("\u00a79" + modeSwitchKey + " To Disable Night Vision")));
            }
        }
        if (((Boolean)stack.getOrDefault(DataComponents.FROST_WALKER, (Object)false)).booleanValue()) {
            if (EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER)) {
                consumer.accept((Component)Component.literal((String)("\u00a79Shift + " + modeSwitchKey + " To Disable Frost Walker")));
            } else {
                consumer.accept((Component)Component.literal((String)("\u00a7c\u00a7lFrost Walker Disabled (Shift + " + modeSwitchKey + ") To Enable")));
            }
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        if (!ToolUtils.isBroken(stack) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)stack.getOrDefault(DataComponents.NIGHT_VISION, (Object)false)).booleanValue() && livingEntity.getItemBySlot(EquipmentSlot.HEAD).equals(stack) && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_NIGHT_VISION, (Object)false)).booleanValue()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, false, false));
            }
        }
        this.levelableInventoryTick(stack, (Level)level, entity, slot, 1.0);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }
}

