/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block;

import com.mojang.serialization.MapCodec;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalToolsMenuProvider;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalQuarryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CrystalQuarryBlock
extends BaseEntityBlock
implements CrystalToolsMenuProvider {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty ACTIVE = BlockStateProperties.LIT;
    public static final MapCodec<CrystalQuarryBlock> CODEC = CrystalQuarryBlock.simpleCodec(CrystalQuarryBlock::new);

    public CrystalQuarryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof CrystalQuarryBlockEntity) {
                CrystalQuarryBlockEntity blockEntity = (CrystalQuarryBlockEntity)t;
                blockEntity.serverTick(level, blockEntity.getBlockPos(), blockState);
            }
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.openContainer(level, pos, player);
        return InteractionResult.CONSUME;
    }

    @Override
    public void openContainer(Level level, BlockPos pos, Player player) {
        CrystalQuarryBlockEntity crystalQuarryBlockEntity;
        block3: {
            block2: {
                BlockEntity be = level.getBlockEntity(pos);
                if (!(be instanceof CrystalQuarryBlockEntity)) break block2;
                crystalQuarryBlockEntity = (CrystalQuarryBlockEntity)be;
                if (player instanceof ServerPlayer) break block3;
            }
            throw new IllegalStateException("Our named container provider is missing!");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.openMenu((MenuProvider)crystalQuarryBlockEntity, registryFriendlyByteBuf -> {
            registryFriendlyByteBuf.writeBlockPos(pos);
            registryFriendlyByteBuf.writeInt(crystalQuarryBlockEntity.getFilterRows());
        });
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystalQuarryBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ACTIVE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean p_393627_) {
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)level, (BlockPos)pos);
    }
}

