/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.client.particle.quarry.breakblock.QuarryBreakParticleData;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.QuarryData;
import dev.willyelton.crystal_tools.common.components.QuarrySettings;
import dev.willyelton.crystal_tools.common.components.QuarryUpgrades;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.energy.CrystalEnergyStorage;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalQuarryContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalQuarryBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputable;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ChunkLoader;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ChunkLoadingAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.LevelableContainerData;
import dev.willyelton.crystal_tools.common.network.data.QuarryMineBlockPayload;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.TransferUtils;
import dev.willyelton.crystal_tools.utils.constants.BlockEntityResourceLocations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CrystalQuarryBlockEntity
extends LevelableBlockEntity
implements MenuProvider,
AutoOutputable,
ChunkLoader {
    public static final int DATA_SIZE = 14;
    private static final int INVENTORY_SIZE = 27;
    private static final int MAX_BLOCKS_PER_TICK = 20;
    private static final ItemStack FORTUNE_STACK = new ItemStack(ModRegistration.CRYSTAL_AIOT);
    private static final ItemStack SILK_TOUCH_STACK = new ItemStack(ModRegistration.CRYSTAL_AIOT);
    private final ItemStacksResourceHandler itemHandler;
    private final ItemStacksResourceHandler filterItemHandler;
    private boolean whitelist = true;
    private int filterRows = 0;
    private CrystalEnergyStorage energyStorage;
    private boolean useDirt = false;
    private boolean silkTouchEnabled;
    private boolean fortuneEnabled;
    private boolean autoOutputEnabled = true;
    private float speedUpgrade = 0.0f;
    private boolean redstoneControl = false;
    private int fortuneLevel = 0;
    private boolean silkTouch = false;
    private int extraEnergyCost;
    private BlockPos miningAt = null;
    private float currentProgress = 0.0f;
    private BlockState miningState = null;
    private boolean finished = false;
    private List<ItemStack> waitingStacks = new ArrayList<ItemStack>();
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int minY;
    private int maxY;
    private List<BlockPos> stabilizerPositions;
    private float centerX;
    private float centerY;
    private float centerZ;
    private AABB aabb;
    private AutoOutputAction autoOutputAction;
    private ChunkLoadingAction chunkLoadingAction;
    protected final ContainerData dataAccess = new LevelableContainerData(this){

        @Override
        protected int getExtra(int index) {
            return switch (index) {
                case 3 -> CrystalQuarryBlockEntity.this.energyStorage.getAmountAsInt();
                case 4 -> CrystalQuarryBlockEntity.this.energyStorage.getCapacityAsInt();
                case 5 -> CrystalQuarryBlockEntity.this.miningAt.getX();
                case 6 -> CrystalQuarryBlockEntity.this.miningAt.getY();
                case 7 -> CrystalQuarryBlockEntity.this.miningAt.getZ();
                case 8 -> {
                    if (CrystalQuarryBlockEntity.this.whitelist) {
                        yield 1;
                    }
                    yield 0;
                }
                case 9 -> {
                    if (CrystalQuarryBlockEntity.this.useDirt) {
                        yield 1;
                    }
                    yield 0;
                }
                case 10 -> {
                    if (CrystalQuarryBlockEntity.this.silkTouchEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                case 11 -> {
                    if (CrystalQuarryBlockEntity.this.fortuneEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                case 12 -> {
                    if (CrystalQuarryBlockEntity.this.autoOutputEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                case 13 -> CrystalQuarryBlockEntity.this.getEnergyCost();
                case 14 -> {
                    if (CrystalQuarryBlockEntity.this.silkTouch) {
                        yield 1;
                    }
                    yield 0;
                }
                case 15 -> CrystalQuarryBlockEntity.this.fortuneLevel;
                case 16 -> {
                    if (CrystalQuarryBlockEntity.this.autoOutputAction.isActive()) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        @Override
        protected void setExtra(int index, int value) {
            switch (index) {
                case 8: {
                    CrystalQuarryBlockEntity.this.whitelist = value == 1;
                    break;
                }
                case 9: {
                    CrystalQuarryBlockEntity.this.useDirt = value == 1;
                    break;
                }
                case 10: {
                    CrystalQuarryBlockEntity.this.silkTouchEnabled = value == 1;
                    break;
                }
                case 11: {
                    CrystalQuarryBlockEntity.this.fortuneEnabled = value == 1;
                    break;
                }
                case 12: {
                    CrystalQuarryBlockEntity.this.autoOutputEnabled = value == 1;
                    CrystalQuarryBlockEntity.this.autoOutputAction.setDisabled(!CrystalQuarryBlockEntity.this.autoOutputEnabled);
                }
            }
        }

        @Override
        protected int getExtraDataSize() {
            return 14;
        }
    };

    public CrystalQuarryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistration.CRYSTAL_QUARRY_BLOCK_ENTITY.get(), pos, state);
        this.itemHandler = new ItemStacksResourceHandler(NonNullList.withSize((int)27, (Object)ItemStack.EMPTY));
        this.energyStorage = new CrystalEnergyStorage(10000, this.getEnergyCost() * 2, 0, 0);
        this.filterItemHandler = new ItemStacksResourceHandler(NonNullList.withSize((int)27, (Object)ItemStack.EMPTY));
    }

    @Override
    protected Collection<Action> getDefaultActions() {
        this.autoOutputAction = new AutoOutputAction((ActionBlockEntity)this, this);
        this.chunkLoadingAction = new ChunkLoadingAction((ActionBlockEntity)this, this);
        return List.of(this.autoOutputAction, this.chunkLoadingAction);
    }

    public ResourceHandler<ItemResource> getItemHandlerCapForSide(Direction side) {
        return this.itemHandler;
    }

    public EnergyHandler getEnergyStorageCapForSide(Direction side) {
        return this.energyStorage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.crystal_tools.crystal_quarry");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CrystalQuarryContainerMenu(containerId, player.level(), this.getBlockPos(), this.filterRows, playerInventory, this.dataAccess);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.itemHandler.deserialize(valueInput);
        this.filterItemHandler.deserialize(valueInput.childOrEmpty("FilterInventory"));
        this.filterRows = valueInput.getInt("FilterRows").orElse(0);
        this.whitelist = valueInput.getBooleanOr("Whitelist", false);
        long pos = valueInput.getLongOr("MiningAt", 0L);
        if (pos != 0L) {
            this.miningAt = BlockPos.of((long)pos);
        }
        this.currentProgress = valueInput.getFloatOr("CurrentProgress", 0.0f);
        this.waitingStacks = new ArrayList<ItemStack>(valueInput.read("WaitingStacks", ItemStack.OPTIONAL_CODEC.listOf()).orElse(new ArrayList()));
        this.finished = valueInput.getBooleanOr("Finished", false);
        this.useDirt = valueInput.getBooleanOr("UseDirt", false);
        this.silkTouchEnabled = valueInput.getBooleanOr("SilkTouchEnabled", false);
        this.fortuneEnabled = valueInput.getBooleanOr("FortuneEnabled", false);
        this.autoOutputEnabled = valueInput.getBooleanOr("AutoOutputEnabled", false);
        this.autoOutputAction.setDisabled(!this.autoOutputEnabled);
        this.minX = valueInput.getInt("MinX").orElse(0);
        this.maxX = valueInput.getInt("MaxX").orElse(0);
        this.minZ = valueInput.getInt("MinZ").orElse(0);
        this.maxZ = valueInput.getInt("MaxZ").orElse(0);
        this.minY = valueInput.getInt("MinY").orElse(0);
        this.maxY = valueInput.getInt("MaxY").orElse(0);
        this.centerX = valueInput.getFloatOr("CenterX", 0.0f);
        this.centerY = valueInput.getFloatOr("CenterY", 0.0f);
        this.centerZ = valueInput.getFloatOr("CenterZ", 0.0f);
        this.speedUpgrade = valueInput.getFloatOr("SpeedUpgrade", 0.0f);
        this.redstoneControl = valueInput.getBooleanOr("RedstoneControl", false);
        this.fortuneLevel = valueInput.getInt("FortuneLevel").orElse(0);
        this.silkTouch = valueInput.getBooleanOr("SilkTouch", false);
        this.extraEnergyCost = valueInput.getInt("ExtraEnergyCost").orElse(0);
        int energy = valueInput.getInt("Energy").orElse(0);
        this.energyStorage = new CrystalEnergyStorage(10000, this.getEnergyCost() * 2, 0, energy);
        this.stabilizerPositions = valueInput.read("StabilizerPositions", Codec.LONG.listOf()).orElse(List.of()).stream().map(BlockPos::of).toList();
        this.createAABB();
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        QuarryData quarryData;
        List stabilizers;
        QuarryUpgrades quarryUpgrades;
        ItemContainerContents filterContents;
        super.applyImplicitComponents(componentInput);
        ItemContainerContents contents = (ItemContainerContents)componentInput.get(net.minecraft.core.component.DataComponents.CONTAINER);
        if (contents != null) {
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack stack = contents.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.itemHandler.set(i, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
            }
        }
        if ((filterContents = (ItemContainerContents)componentInput.get(DataComponents.FILTER_INVENTORY)) != null) {
            for (int i = 0; i < filterContents.getSlots(); ++i) {
                ItemStack stack = filterContents.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.filterItemHandler.set(i, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
            }
        }
        if ((quarryUpgrades = (QuarryUpgrades)componentInput.get(DataComponents.QUARRY_UPGRADES)) != null) {
            this.speedUpgrade = quarryUpgrades.speedUpgrade();
            this.redstoneControl = quarryUpgrades.redstoneControl();
            this.fortuneLevel = quarryUpgrades.fortuneLevel();
            this.silkTouch = quarryUpgrades.silkTouch();
            this.extraEnergyCost = quarryUpgrades.extraEnergyCost();
            this.filterRows = quarryUpgrades.filterRows();
        }
        if ((stabilizers = (List)componentInput.get(DataComponents.QUARRY_BOUNDS)) != null) {
            this.setStabilizers(stabilizers);
        }
        if ((quarryData = (QuarryData)componentInput.get(DataComponents.QUARRY_DATA)) != null) {
            this.miningAt = quarryData.miningAt();
            this.currentProgress = quarryData.currentProgress();
            this.miningState = quarryData.miningState();
            this.finished = quarryData.finished();
            this.waitingStacks = new ArrayList<ItemStack>(quarryData.waitingStacks());
            this.energyStorage = new CrystalEnergyStorage(10000, this.getEnergyCost() * 2, 0, quarryData.currentEnergy());
            this.whitelist = quarryData.whitelist();
        } else {
            this.energyStorage = new CrystalEnergyStorage(10000, this.getEnergyCost() * 2, 0, 0);
        }
        QuarrySettings quarrySettings = (QuarrySettings)componentInput.get(DataComponents.QUARRY_SETTINGS);
        if (quarrySettings != null) {
            this.useDirt = quarrySettings.useDirt();
            this.silkTouchEnabled = quarrySettings.silkTouchEnabled();
            this.fortuneEnabled = quarrySettings.fortuneEnabled();
            this.autoOutputEnabled = quarrySettings.autoOutputEnabled();
            this.autoOutputAction.setDisabled(!this.autoOutputEnabled);
        }
        this.createAABB();
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.itemHandler.serialize(valueOutput);
        this.filterItemHandler.serialize(valueOutput.child("FilterInventory"));
        valueOutput.putInt("FilterRows", this.filterRows);
        valueOutput.putBoolean("Whitelist", this.whitelist);
        if (this.miningAt != null) {
            valueOutput.putLong("MiningAt", this.miningAt.asLong());
        }
        valueOutput.putFloat("CurrentProgress", this.currentProgress);
        if (!this.waitingStacks.isEmpty()) {
            valueOutput.store("WaitingStacks", ItemStack.OPTIONAL_CODEC.listOf(), this.waitingStacks);
        }
        valueOutput.putBoolean("Finished", this.finished);
        valueOutput.putBoolean("UseDirt", this.useDirt);
        valueOutput.putBoolean("SilkTouchEnabled", this.silkTouchEnabled);
        valueOutput.putBoolean("FortuneEnabled", this.fortuneEnabled);
        valueOutput.putBoolean("AutoOutputEnabled", this.autoOutputEnabled);
        valueOutput.putInt("MinX", this.minX);
        valueOutput.putInt("MaxX", this.maxX);
        valueOutput.putInt("MinZ", this.minZ);
        valueOutput.putInt("MaxZ", this.maxZ);
        valueOutput.putInt("MinY", this.minY);
        valueOutput.putInt("MaxY", this.maxY);
        valueOutput.putFloat("CenterX", this.centerX);
        valueOutput.putFloat("CenterY", this.centerY);
        valueOutput.putFloat("CenterZ", this.centerZ);
        valueOutput.putInt("Energy", this.energyStorage.getAmountAsInt());
        valueOutput.putFloat("SpeedUpgrade", this.speedUpgrade);
        valueOutput.putBoolean("RedstoneControl", this.redstoneControl);
        valueOutput.putInt("FortuneLevel", this.fortuneLevel);
        valueOutput.putBoolean("SilkTouch", this.silkTouch);
        valueOutput.putInt("ExtraEnergyCost", this.extraEnergyCost);
        if (this.stabilizerPositions != null) {
            valueOutput.store("StabilizerPositions", Codec.LONG.listOf(), this.stabilizerPositions.stream().mapToLong(BlockPos::asLong).boxed().toList());
        }
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        ItemContainerContents contents = ItemContainerContents.fromItems((List)this.itemHandler.copyToList());
        components.set(net.minecraft.core.component.DataComponents.CONTAINER, (Object)contents);
        ItemContainerContents filterContents = ItemContainerContents.fromItems((List)this.filterItemHandler.copyToList());
        components.set(DataComponents.FILTER_INVENTORY, (Object)filterContents);
        QuarryData quarryData = new QuarryData(this.miningAt == null ? BlockPos.ZERO : this.miningAt, this.currentProgress, this.miningState, this.finished, this.waitingStacks, this.energyStorage.getAmountAsInt(), this.whitelist);
        components.set(DataComponents.QUARRY_DATA, (Object)quarryData);
        QuarryUpgrades quarryUpgrades = new QuarryUpgrades(this.speedUpgrade, this.redstoneControl, this.fortuneLevel, this.silkTouch, this.extraEnergyCost, this.filterRows);
        components.set(DataComponents.QUARRY_UPGRADES, (Object)quarryUpgrades);
        QuarrySettings quarrySettings = new QuarrySettings(this.useDirt, this.silkTouchEnabled, this.fortuneEnabled, this.autoOutputEnabled);
        components.set(DataComponents.QUARRY_SETTINGS, (Object)quarrySettings);
        components.set(DataComponents.QUARRY_BOUNDS, this.stabilizerPositions);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.enchantTempItems(level);
    }

    @Override
    protected void addToExtraData(String key, float value) {
        if (BlockEntityResourceLocations.MINING_SPEED.toString().equals(key)) {
            this.speedUpgrade += value;
            this.extraEnergyCost += Math.max(1, (int)((float)((Integer)CrystalToolsConfig.QUARRY_SPEED_COST_INCREASE.get()).intValue() * value));
            this.updateEnergyStorage();
        } else if (BlockEntityResourceLocations.REDSTONE_CONTROL.toString().equals(key)) {
            this.redstoneControl = true;
        } else if (BlockEntityResourceLocations.FORTUNE.toString().equals(key)) {
            this.fortuneLevel += (int)value;
            this.fortuneEnabled = !this.silkTouch || !this.silkTouchEnabled;
            this.enchantTempItems(this.level);
            this.extraEnergyCost += ((Integer)CrystalToolsConfig.QUARRY_FORTUNE_COST_INCREASE.get()).intValue();
            this.updateEnergyStorage();
        } else if (BlockEntityResourceLocations.SILK_TOUCH.toString().equals(key)) {
            this.silkTouch = true;
            this.silkTouchEnabled = this.fortuneLevel == 0 || !this.fortuneEnabled;
            this.enchantTempItems(this.level);
            this.extraEnergyCost += ((Integer)CrystalToolsConfig.QUARRY_SILK_TOUCH_COST_INCREASE.get()).intValue();
            this.updateEnergyStorage();
        } else if (BlockEntityResourceLocations.TRASH_FILTER.toString().equals(key)) {
            this.filterRows += (int)value;
        }
    }

    @Override
    protected void resetExtraSkills() {
        super.resetExtraSkills();
        this.speedUpgrade = 0.0f;
        this.redstoneControl = false;
        this.fortuneLevel = 0;
        this.silkTouch = false;
        this.filterRows = 0;
        this.whitelist = true;
        this.extraEnergyCost = 0;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean hasRedstone = level.hasNeighborSignal(pos);
        if (hasRedstone && this.redstoneControl) {
            if (((Boolean)state.getValue((Property)CrystalQuarryBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)CrystalQuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 3);
            }
            return;
        }
        if (this.finished) {
            return;
        }
        if (this.miningAt == null) {
            return;
        }
        super.serverTick(level, pos, state);
        if (!this.waitingStacks.isEmpty()) {
            if (level.getGameTime() % 20L == 0L) {
                ArrayList<ItemStack> noFit = new ArrayList<ItemStack>(InventoryUtils.tryInsertStacks((ResourceHandler<ItemResource>)this.itemHandler, this.waitingStacks, this::shouldPickUp));
                if (!noFit.isEmpty()) {
                    this.waitingStacks = noFit;
                    return;
                }
                this.waitingStacks.clear();
            } else {
                return;
            }
        }
        if (!level.isLoaded(this.miningAt)) {
            if (this.chunkLoadingAction.isActive()) {
                this.chunkLoadingAction.loadChunk((ServerLevel)level, new ChunkPos(this.miningAt));
            } else {
                return;
            }
        }
        int energyCost = this.getEnergyCost();
        if (this.energyStorage.getAmountAsInt() >= energyCost) {
            this.energyStorage.removeEnergy(energyCost);
            if (!((Boolean)state.getValue((Property)CrystalQuarryBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)CrystalQuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 3);
            }
        } else {
            if (((Boolean)state.getValue((Property)CrystalQuarryBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)CrystalQuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 3);
            }
            return;
        }
        this.setChanged();
        if (this.miningState == null) {
            int blocksThisTick = 0;
            while (!this.finished && blocksThisTick < 20) {
                if (this.canMine(level.getBlockState(this.miningAt))) {
                    this.miningState = level.getBlockState(this.miningAt);
                    if (!this.miningState.getFluidState().isEmpty()) {
                        BlockState blockState = this.useDirt ? Blocks.DIRT.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        level.setBlock(this.miningAt, blockState, 3);
                        ++blocksThisTick;
                        this.miningState = null;
                        this.nextPosition();
                        continue;
                    }
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(this.miningAt), (CustomPacketPayload)new QuarryMineBlockPayload(this.getBlockPos(), this.miningAt, this.miningState), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                ++blocksThisTick;
                this.nextPosition();
            }
            if (this.miningState == null) {
                return;
            }
        }
        this.currentProgress += this.getDestroyProgress(this.miningState, (BlockGetter)level, this.miningAt);
        if (level.getGameTime() % 2L == 0L) {
            this.spawnBreakingParticles((ServerLevel)level);
        }
        if (this.currentProgress >= 10.0f) {
            if (this.miningState.equals((Object)level.getBlockState(this.miningAt))) {
                ItemStack miningStack = ItemStack.EMPTY;
                if (this.fortuneLevel > 0 && this.fortuneEnabled) {
                    miningStack = FORTUNE_STACK;
                } else if (this.silkTouch && this.silkTouchEnabled) {
                    miningStack = SILK_TOUCH_STACK;
                }
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>(Block.getDrops((BlockState)level.getBlockState(this.miningAt), (ServerLevel)((ServerLevel)level), (BlockPos)this.miningAt, (BlockEntity)level.getBlockEntity(this.miningAt), null, (ItemStack)miningStack));
                drops.addAll(this.getInventoryContents(level));
                ArrayList<ItemStack> noFit = new ArrayList<ItemStack>(InventoryUtils.tryInsertStacks((ResourceHandler<ItemResource>)this.itemHandler, drops, this::shouldPickUp));
                if (!noFit.isEmpty()) {
                    this.waitingStacks = noFit;
                }
                level.destroyBlock(this.miningAt, false, null);
                if (this.useDirt) {
                    level.setBlock(this.miningAt, Blocks.DIRT.defaultBlockState(), 3);
                }
                this.addExp(1);
                this.nextPosition();
                this.setChanged();
            }
            this.miningState = null;
            this.currentProgress = 0.0f;
        } else {
            level.destroyBlockProgress(-1, this.miningAt, (int)this.currentProgress);
        }
    }

    public ItemStacksResourceHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemStacksResourceHandler getFilterItemHandler() {
        return this.filterItemHandler;
    }

    public int getFilterRows() {
        return this.filterRows;
    }

    public void setStabilizers(List<BlockPos> positions) {
        this.setPositions(positions.get(0), positions.get(2).atY(-64));
        this.stabilizerPositions = positions;
        this.createAABB();
    }

    private void setPositions(BlockPos topCorner, BlockPos bottomCorner) {
        this.minX = Math.min(topCorner.getX(), bottomCorner.getX()) + 1;
        this.maxX = Math.max(topCorner.getX(), bottomCorner.getX()) - 1;
        this.minZ = Math.min(topCorner.getZ(), bottomCorner.getZ()) + 1;
        this.maxZ = Math.max(topCorner.getZ(), bottomCorner.getZ()) - 1;
        this.minY = Math.min(topCorner.getY(), bottomCorner.getY());
        this.maxY = Math.max(topCorner.getY(), bottomCorner.getY());
        this.miningAt = new BlockPos(this.minX, this.maxY, this.minZ);
        this.centerX = (float)(this.maxX - this.minX) / 2.0f + (float)this.minX;
        this.centerY = this.maxY + 3;
        this.centerZ = (float)(this.maxZ - this.minZ) / 2.0f + (float)this.minZ;
    }

    private int getEnergyCost() {
        int cost = (Integer)CrystalToolsConfig.QUARRY_BASE_ENERGY_COST.get() + this.extraEnergyCost;
        if (this.silkTouch && !this.silkTouchEnabled) {
            cost -= ((Integer)CrystalToolsConfig.QUARRY_SILK_TOUCH_COST_INCREASE.get()).intValue();
        }
        if (this.fortuneLevel > 0 && !this.fortuneEnabled) {
            cost -= ((Integer)CrystalToolsConfig.QUARRY_FORTUNE_COST_INCREASE.get()).intValue();
        }
        return cost;
    }

    private boolean canMine(BlockState state) {
        return !state.isAir() && state.getDestroySpeed((BlockGetter)this.level, this.worldPosition) >= 0.0f;
    }

    private void nextPosition() {
        int currentX = this.miningAt.getX();
        int currentY = this.miningAt.getY();
        int currentZ = this.miningAt.getZ();
        if (++currentX > this.maxX) {
            currentX = this.minX;
            if (++currentZ > this.maxZ) {
                currentZ = this.minZ;
                if (--currentY < this.minY) {
                    this.finished = true;
                    this.chunkLoadingAction.unloadAll((ServerLevel)this.level);
                    BlockState state = (BlockState)this.getBlockState().setValue((Property)CrystalQuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                    this.level.setBlock(this.getBlockPos(), state, 3);
                }
            }
        }
        this.miningAt = new BlockPos(currentX, currentY, currentZ);
    }

    private float getDestroyProgress(BlockState state, BlockGetter level, BlockPos pos) {
        float f = state.getDestroySpeed(level, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        return (float)((9.0 + (double)this.speedUpgrade * (Double)CrystalToolsConfig.QUARRY_SPEED_UPGRADE_MULTIPLIER.get()) / (double)f / 30.0);
    }

    private List<ItemStack> getInventoryContents(Level level) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Direction direction : Direction.values()) {
            ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, this.miningAt, this.miningState, level.getBlockEntity(this.miningAt), (Object)direction);
            if (handler == null) continue;
            stacks.addAll(TransferUtils.extractAll((ResourceHandler<ItemResource>)handler));
        }
        return stacks;
    }

    private void enchantTempItems(Level level) {
        level.registryAccess().lookup(Registries.ENCHANTMENT).ifPresent(enchantments -> {
            FORTUNE_STACK.enchant((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), this.fortuneLevel);
            SILK_TOUCH_STACK.enchant((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), 1);
        });
    }

    private boolean shouldPickUp(ItemStack stack) {
        ItemResource resource = ItemResource.of((ItemStack)stack);
        if (!resource.isEmpty()) {
            try (Transaction tx = Transaction.open(null);){
                boolean hasItem;
                boolean bl = hasItem = this.filterItemHandler.extract((Resource)resource, 1, (TransactionContext)tx) == 1;
                if (hasItem) {
                    boolean bl2 = !this.whitelist;
                    return bl2;
                }
            }
        }
        return this.whitelist;
    }

    @Override
    public Map<Integer, ItemStack> getOutputStacks() {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.itemHandler.size(); ++i) {
            if (((ItemResource)this.itemHandler.getResource(i)).isEmpty()) continue;
            items.put(i, ItemUtil.getStack((ResourceHandler)this.itemHandler, (int)i));
        }
        return items;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.itemHandler.set(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount());
    }

    @Override
    protected int getBaseExpCap() {
        return (Integer)CrystalToolsConfig.QUARRY_BASE_EXPERIENCE_CAP.get();
    }

    private void updateEnergyStorage() {
        this.energyStorage.maxInsert(this.getEnergyCost() * 2);
    }

    public BlockPos getMiningAt() {
        return this.miningAt;
    }

    public void setMiningAt(BlockPos miningAt) {
        this.miningAt = miningAt;
    }

    public void setMiningState(BlockState miningState) {
        this.miningState = miningState;
    }

    public List<BlockPos> getStabilizerPositions() {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        result.add(new BlockPos(this.minX - 1, this.maxY, this.minZ - 1));
        result.add(new BlockPos(this.minX - 1, this.maxY, this.maxZ + 1));
        result.add(new BlockPos(this.maxX + 1, this.maxY, this.maxZ + 1));
        result.add(new BlockPos(this.maxX + 1, this.maxY, this.minZ - 1));
        return result;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void createAABB() {
        this.aabb = AABB.encapsulatingFullBlocks((BlockPos)this.stabilizerPositions.get(0).atY(-64), (BlockPos)this.stabilizerPositions.get(2).above(4));
    }

    public AABB getAABB() {
        return this.aabb;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    private void spawnBreakingParticles(ServerLevel level) {
        BlockPos pos = this.getBlockPos();
        level.sendParticles((ParticleOptions)new QuarryBreakParticleData(this.miningState, this.miningAt, pos), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, 0.25, 0.25, 0.25, 0.1);
    }

    @Override
    public boolean shouldUnload() {
        return this.finished || this.isRemoved();
    }
}

