/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Action {
    protected ActionBlockEntity blockEntity;
    protected ActionParameters params;
    protected int tickCounter = 0;

    public Action(ActionBlockEntity blockEntity, @Nullable ActionParameters params) {
        this.blockEntity = blockEntity;
        this.params = params == null ? this.getDefaultParameters() : params;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.isActive() || this.params.maxTickCounter() == -1) {
            return;
        }
        if (++this.tickCounter >= this.params.maxTickCounter() && level != null) {
            this.tickAction(level, pos, state);
            this.tickCounter = 0;
        }
    }

    public void tickAction(@NotNull Level level, BlockPos pos, BlockState state) {
    }

    public abstract ActionType getActionType();

    public abstract ActionParameters getDefaultParameters();

    public void load(ValueInput valueInput) {
    }

    public void save(ValueOutput valueOutput) {
    }

    public void onRemove() {
    }

    public void applyComponents(DataComponentGetter componentInput) {
    }

    public void collectComponents(DataComponentMap.Builder components) {
    }

    public boolean addToExtra(String key, float value) {
        return false;
    }

    public void resetExtra() {
    }

    public boolean isActive() {
        return false;
    }

    protected ItemStack getItem() {
        ActionBlockEntity actionBlockEntity = this.blockEntity;
        if (actionBlockEntity instanceof CrystalPedestalBlockEntity) {
            CrystalPedestalBlockEntity pedestalBlockEntity = (CrystalPedestalBlockEntity)actionBlockEntity;
            return pedestalBlockEntity.getStack() == null ? ItemStack.EMPTY : pedestalBlockEntity.getStack();
        }
        return ItemStack.EMPTY;
    }
}

