/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputable;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import dev.willyelton.crystal_tools.utils.constants.BlockEntityResourceLocations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class AutoOutputAction
extends Action {
    private static final Direction[] POSSIBLE_INVENTORIES = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final AutoOutputable autoOutputable;
    private boolean autoOutputEnabled = false;
    private boolean disabled = false;

    public AutoOutputAction(ActionBlockEntity blockEntity, ActionParameters params, AutoOutputable autoOutputEnabled) {
        super(blockEntity, params);
        this.autoOutputable = autoOutputEnabled;
    }

    public AutoOutputAction(ActionBlockEntity blockEntity, AutoOutputable autoOutputEnabled) {
        this(blockEntity, null, autoOutputEnabled);
    }

    @Override
    public void tickAction(Level level, BlockPos pos, BlockState state) {
        if (this.disabled || !this.autoOutputEnabled) {
            return;
        }
        for (Integer index : this.autoOutputable.getOutputStacks().keySet()) {
            ItemStack stack = this.autoOutputable.getOutputStacks().get(index);
            if (stack.isEmpty()) continue;
            for (Direction dir : POSSIBLE_INVENTORIES) {
                ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos.relative(dir), (Object)dir.getOpposite());
                BlockState invState = level.getBlockState(pos.relative(dir));
                if (handler != null && !invState.is(CrystalToolsTags.AUTO_OUTPUT_BLACKLIST)) {
                    try (Transaction tx = Transaction.open(null);){
                        int inserted = handler.insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)tx);
                        stack.shrink(inserted);
                        tx.commit();
                    }
                }
                if (stack.isEmpty()) break;
            }
            this.autoOutputable.setItem(index, stack);
        }
    }

    @Override
    public void load(ValueInput valueInput) {
        this.autoOutputEnabled = valueInput.getBooleanOr("AutoOutput", false);
    }

    @Override
    public void save(ValueOutput valueOutput) {
        valueOutput.putBoolean("AutoOutput", this.autoOutputEnabled);
    }

    @Override
    public boolean addToExtra(String key, float value) {
        if (BlockEntityResourceLocations.AUTO_OUTPUT.toString().equals(key)) {
            this.autoOutputEnabled = true;
            return true;
        }
        return false;
    }

    @Override
    public void resetExtra() {
        this.autoOutputEnabled = false;
    }

    @Override
    public boolean isActive() {
        return this.autoOutputEnabled;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.AUTO_OUTPUT;
    }

    @Override
    public ActionParameters getDefaultParameters() {
        return new ActionParameters(100);
    }

    @Override
    public void applyComponents(DataComponentGetter componentInput) {
        super.applyComponents(componentInput);
        this.autoOutputEnabled = (Boolean)componentInput.getOrDefault(DataComponents.AUTO_OUTPUT, (Object)false);
    }

    @Override
    public void collectComponents(DataComponentMap.Builder components) {
        super.collectComponents(components);
        components.set(DataComponents.AUTO_OUTPUT, (Object)this.autoOutputEnabled);
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

