/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.inventory.PortableGeneratorInventory;
import dev.willyelton.crystal_tools.common.levelable.PortableGenerator;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargingAction
extends Action {
    private final Set<Integer> chargingEntities = new HashSet<Integer>();

    public ChargingAction(ActionBlockEntity blockEntity, @Nullable ActionParameters params) {
        super(blockEntity, params);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.CHARGE;
    }

    @Override
    public ActionParameters getDefaultParameters() {
        return new ActionParameters(1, -1.0f, 10);
    }

    @Override
    public void tickAction(@NotNull Level level, BlockPos pos, BlockState state) {
        Vec3 centerPos = pos.getCenter();
        ItemStack stack = this.getItem();
        if (level.getGameTime() % 100L == 32L) {
            List entities = level.getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)centerPos, (double)(this.params.range() * 2), (double)(this.params.range() * 2), (double)(this.params.range() * 2)));
            this.chargingEntities.clear();
            this.chargingEntities.addAll(entities.stream().map(Entity::getId).collect(Collectors.toSet()));
        }
        if (!stack.isEmpty()) {
            PortableGenerator.tick(stack, level, this.getEntitiesToCharge(level), pos, () -> this.getItemStack(stack, level, pos), (Boolean)CrystalToolsConfig.LEVEL_ITEMS_IN_PEDESTAL.get());
        }
    }

    private ItemStack getItemStack(ItemStack stack, Level level, BlockPos pos) {
        ItemStack result = ItemStack.EMPTY;
        ResourceHandler handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos, null);
        if (handler != null) {
            result = ItemStackUtils.nextFuelItem((ResourceHandler<ItemResource>)handler, itemResource -> PortableGeneratorInventory.canBurn(stack, itemResource.toStack(), level));
        }
        if (result.isEmpty()) {
            return PortableGenerator.getNextFuelStack(stack, level);
        }
        return result;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    private List<Entity> getEntitiesToCharge(Level level) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        Iterator<Integer> iterator = this.chargingEntities.iterator();
        while (iterator.hasNext()) {
            int entityId = iterator.next();
            Entity entity = level.getEntity(entityId);
            if (entity != null) {
                result.add(entity);
                continue;
            }
            iterator.remove();
        }
        return result;
    }
}

