/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ChunkLoader;
import dev.willyelton.crystal_tools.utils.constants.BlockEntityResourceLocations;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.world.chunk.LoadingValidationCallback;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import org.jetbrains.annotations.Nullable;

public class ChunkLoadingAction
extends Action {
    public static final TicketController TICKET_CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"chunk_loader"), (LoadingValidationCallback)ChunkLoadingValidationCallback.INSTANCE);
    private final ChunkLoader chunkLoader;
    private boolean chunkLoadingEnabled;
    private final Set<Long> chunkSet = new HashSet<Long>();

    public ChunkLoadingAction(ActionBlockEntity blockEntity, @Nullable ActionParameters params, ChunkLoader chunkLoader) {
        super(blockEntity, params);
        this.chunkLoader = chunkLoader;
    }

    public ChunkLoadingAction(ActionBlockEntity blockEntity, ChunkLoader chunkLoader) {
        this(blockEntity, null, chunkLoader);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.CHUNK_LOAD;
    }

    @Override
    public ActionParameters getDefaultParameters() {
        return new ActionParameters(20);
    }

    @Override
    public void load(ValueInput valueInput) {
        this.chunkLoadingEnabled = valueInput.getBooleanOr("ChunkLoading", false);
        this.chunkSet.addAll(valueInput.read("ChunkSet", Codec.LONG.listOf()).orElse(List.of()));
    }

    @Override
    public void save(ValueOutput valueOutput) {
        valueOutput.putBoolean("ChunkLoading", this.chunkLoadingEnabled);
        valueOutput.store("ChunkSet", Codec.LONG.listOf(), this.chunkSet.stream().toList());
    }

    @Override
    public boolean addToExtra(String key, float value) {
        if (BlockEntityResourceLocations.CHUNK_LOADING.toString().equals(key)) {
            this.chunkLoadingEnabled = true;
            this.loadChunk((ServerLevel)this.blockEntity.getLevel(), new ChunkPos(this.blockEntity.getBlockPos()));
            return true;
        }
        return false;
    }

    @Override
    public void onRemove() {
        Level level = this.blockEntity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.unloadAll(serverLevel);
        }
    }

    @Override
    public void applyComponents(DataComponentGetter componentInput) {
        super.applyComponents(componentInput);
        this.chunkLoadingEnabled = (Boolean)componentInput.getOrDefault(DataComponents.CHUNKLOADING, (Object)false);
    }

    @Override
    public void collectComponents(DataComponentMap.Builder components) {
        super.collectComponents(components);
        components.set(DataComponents.CHUNKLOADING, (Object)this.chunkLoadingEnabled);
    }

    @Override
    public void resetExtra() {
        this.chunkLoadingEnabled = false;
    }

    @Override
    public boolean isActive() {
        return this.chunkLoadingEnabled;
    }

    public void loadChunk(ServerLevel level, ChunkPos chunkPos) {
        boolean ticking = this.chunkLoader.shouldTickChunk(chunkPos);
        this.chunkSet.add(chunkPos.toLong());
        this.blockEntity.setChanged();
        TICKET_CONTROLLER.forceChunk(level, this.blockEntity.getBlockPos(), chunkPos.x, chunkPos.z, true, ticking);
    }

    public void unloadChunk(ServerLevel level, ChunkPos chunkPos) {
        boolean ticking = this.chunkLoader.shouldTickChunk(chunkPos);
        this.chunkSet.remove(chunkPos.toLong());
        this.blockEntity.setChanged();
        TICKET_CONTROLLER.forceChunk(level, this.blockEntity.getBlockPos(), chunkPos.x, chunkPos.z, false, ticking);
    }

    public void unloadAll(ServerLevel serverLevel) {
        for (Long chunkLong : this.chunkSet) {
            ChunkPos chunkPos = new ChunkPos(chunkLong.longValue());
            TICKET_CONTROLLER.forceChunk(serverLevel, this.blockEntity.getBlockPos(), chunkPos.x, chunkPos.z, false, true);
            TICKET_CONTROLLER.forceChunk(serverLevel, this.blockEntity.getBlockPos(), chunkPos.x, chunkPos.z, false, false);
        }
        this.chunkSet.clear();
        this.blockEntity.setChanged();
    }

    private static class ChunkLoadingValidationCallback
    implements LoadingValidationCallback {
        static final ChunkLoadingValidationCallback INSTANCE = new ChunkLoadingValidationCallback();

        private ChunkLoadingValidationCallback() {
        }

        public void validateTickets(ServerLevel level, TicketHelper ticketHelper) {
            for (Map.Entry entries : ticketHelper.getBlockTickets().entrySet()) {
                BlockPos pos = (BlockPos)entries.getKey();
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof ChunkLoader) {
                    ChunkLoader chunkLoader = (ChunkLoader)blockEntity;
                    if (!chunkLoader.shouldUnload()) continue;
                    ticketHelper.removeAllTickets(pos);
                    continue;
                }
                ticketHelper.removeAllTickets(pos);
            }
        }
    }
}

