/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagnetAction
extends Action {
    private final Set<Integer> pullingEntities = new HashSet<Integer>();

    public MagnetAction(ActionBlockEntity blockEntity, @Nullable ActionParameters params) {
        super(blockEntity, params);
    }

    @Override
    public void tickAction(@NotNull Level level, BlockPos pos, BlockState state) {
        Vec3 centerPos = pos.getCenter();
        ItemStack stack = this.getItem();
        if (ToolUtils.isBroken(stack) || ((Boolean)stack.getOrDefault(DataComponents.DISABLED, (Object)false)).booleanValue()) {
            return;
        }
        if (level.getGameTime() % 20L == 6L) {
            float range = (float)this.params.range() + ((Float)stack.getOrDefault(DataComponents.MAGNET_RANGE, (Object)Float.valueOf(0.0f))).floatValue();
            List itemEntities = level.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)centerPos, (double)(range * 2.0f), (double)(range * 2.0f), (double)(range * 2.0f)));
            this.pullingEntities.clear();
            this.pullingEntities.addAll(itemEntities.stream().map(Entity::getId).collect(Collectors.toSet()));
        }
        Iterator<Integer> iterator = this.pullingEntities.iterator();
        while (iterator.hasNext()) {
            Integer entityId = iterator.next();
            Entity entity = level.getEntity(entityId.intValue());
            if (entity instanceof ItemEntity) {
                Levelable levelable;
                ItemEntity itemEntity = (ItemEntity)entity;
                itemEntity.push(centerPos.subtract(itemEntity.position()).normalize().scale((double)this.getSpeed(stack)));
                if (!this.canPickup(pos, itemEntity, stack) || !this.storeItem(level, pos, itemEntity)) continue;
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(Mth.ceil((float)this.params.durabilityModifier()), (ServerLevel)level, null, item -> {});
                }
                if ((levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) != null && ((Boolean)CrystalToolsConfig.LEVEL_ITEMS_IN_PEDESTAL.get()).booleanValue()) {
                    levelable.addExp(level, pos, null);
                }
                itemEntity.discard();
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private boolean canPickup(BlockPos pos, ItemEntity itemEntity, ItemStack magnetStack) {
        return (Boolean)magnetStack.getOrDefault(DataComponents.INSTANT_PICKUP, (Object)false) != false || itemEntity.distanceToSqr(pos.getCenter()) <= (double)2.3f;
    }

    private boolean storeItem(Level level, BlockPos pos, ItemEntity itemEntity) {
        ResourceHandler handler;
        ItemStack stack = itemEntity.getItem();
        ItemResource resource = ItemResource.of((ItemStack)stack);
        if (!resource.isEmpty() && (handler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos, null)) != null) {
            int inserted = ResourceHandlerUtil.insertStacking((ResourceHandler)handler, (Resource)resource, (int)stack.getCount(), null);
            ItemStack leftOver = stack.copyWithCount(stack.getCount() - inserted);
            if (leftOver.isEmpty()) {
                return true;
            }
            itemEntity.setItem(leftOver);
            return false;
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.MAGNET;
    }

    @Override
    public ActionParameters getDefaultParameters() {
        return new ActionParameters(5, 5.0f, 5);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    private float getSpeed(ItemStack stack) {
        return 0.01f + ((Float)stack.getOrDefault(DataComponents.ITEM_SPEED, (Object)Float.valueOf(0.0f))).floatValue();
    }
}

