/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.data;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ILevelableContainerData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import net.minecraft.world.item.ItemStack;

public abstract class ItemStackLevelableContainerData
implements ILevelableContainerData {
    protected static final int DATA_SIZE = 3;
    private final ItemStack stack;

    public ItemStackLevelableContainerData(ItemStack stack) {
        this.stack = stack;
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
            case 1 -> (Integer)this.stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
            case 2 -> (Integer)this.stack.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)0);
            default -> index >= this.getNonSkillDataSize() && index < this.getCount() ? ((SkillPoints)this.stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).getPoints(index - this.getNonSkillDataSize()) : this.getExtra(index);
        };
    }

    protected abstract int getExtra(int var1);

    public void set(int index, int value) {
        switch (index) {
            case 0: {
                this.stack.set(DataComponents.SKILL_POINTS, (Object)value);
                break;
            }
            case 1: {
                this.stack.set(DataComponents.SKILL_EXPERIENCE, (Object)value);
                break;
            }
            case 2: {
                this.stack.set(DataComponents.EXPERIENCE_CAP, (Object)value);
                break;
            }
            default: {
                if (index >= this.getNonSkillDataSize() && index < this.getCount()) {
                    SkillPoints skillPoints = ((SkillPoints)this.stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).copy();
                    skillPoints.setPoints(index - this.getNonSkillDataSize(), value);
                    this.stack.set(DataComponents.SKILL_POINT_DATA, (Object)skillPoints);
                    break;
                }
                this.setExtra(index, value);
            }
        }
    }

    protected abstract void setExtra(int var1, int var2);

    public int getCount() {
        return this.getNonSkillDataSize() + 100;
    }

    protected abstract int getExtraDataSize();

    private int getNonSkillDataSize() {
        return this.getExtraDataSize() + 3;
    }

    @Override
    public int getSkillPoints() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    @Override
    public void addSkillPoints(int points) {
        this.stack.set(DataComponents.SKILL_POINTS, (Object)(points + this.getSkillPoints()));
    }

    @Override
    public void addToPoints(int nodeId, int value) {
        SkillPoints skillPoints = ((SkillPoints)this.stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).copy();
        skillPoints.addPoints(nodeId, value);
        this.stack.set(DataComponents.SKILL_POINT_DATA, (Object)skillPoints);
    }

    @Override
    public int getExp() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0);
    }

    @Override
    public int getExpCap() {
        return (Integer)this.stack.getOrDefault(DataComponents.EXPERIENCE_CAP, (Object)0);
    }

    @Override
    public SkillPoints getPoints() {
        return (SkillPoints)this.stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
    }
}

