/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.data;

import dev.willyelton.crystal_tools.common.levelable.block.entity.data.ILevelableContainerData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;

public class SimpleLevelableContainerData
implements ILevelableContainerData {
    private final int extraData;
    private final int[] data;

    public SimpleLevelableContainerData(int extraData) {
        this.extraData = extraData;
        this.data = new int[extraData + 3 + 100];
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    public int getCount() {
        return this.extraData + 3 + 100;
    }

    @Override
    public int getSkillPoints() {
        return this.data[0];
    }

    @Override
    public void addSkillPoints(int points) {
        this.set(0, this.getSkillPoints() + points);
    }

    @Override
    public void addToPoints(int nodeId, int value) {
        int index = nodeId + 3 + this.extraData;
        this.set(index, this.get(index) + value);
    }

    @Override
    public int getExp() {
        return this.get(1);
    }

    @Override
    public int getExpCap() {
        return this.get(2);
    }

    @Override
    public SkillPoints getPoints() {
        SkillPoints points = new SkillPoints();
        for (int i = 0; i < 100; ++i) {
            int stored = this.get(i + 3 + this.extraData);
            if (stored <= 0) continue;
            points.setPoints(i, stored);
        }
        return points;
    }
}

