/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SkillPoints {
    private static final Codec<Integer> STRINT = Codec.STRING.xmap(Integer::parseInt, String::valueOf);
    public static final Codec<SkillPoints> CODEC = Codec.unboundedMap(STRINT, (Codec)Codec.INT).xmap(SkillPoints::new, SkillPoints::getPointMap);
    public static final StreamCodec<ByteBuf, SkillPoints> STREAM_CODEC = ByteBufCodecs.map(SkillPoints::mapGetter, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ByteBufCodecs.INT).map(SkillPoints::new, SkillPoints::getPointMap);
    private final Map<Integer, Integer> pointMap;
    private int totalPoints;

    public SkillPoints() {
        this.pointMap = new HashMap<Integer, Integer>();
        this.totalPoints = 0;
    }

    private SkillPoints(Map<Integer, Integer> pointMap) {
        this.pointMap = new HashMap<Integer, Integer>(pointMap);
        this.totalPoints = pointMap.values().stream().mapToInt(integer -> integer).sum();
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    public void addPoints(int id, int points) {
        this.totalPoints += points;
        this.pointMap.compute(id, (k, v) -> v == null ? points : v + points);
    }

    public int getPoints(int id) {
        return this.pointMap.get(id) == null ? 0 : this.pointMap.get(id);
    }

    public void setPoints(int id, int points) {
        this.pointMap.put(id, points);
    }

    public SkillPoints copy() {
        HashMap<Integer, Integer> newPointMap = new HashMap<Integer, Integer>(this.pointMap);
        return new SkillPoints(newPointMap);
    }

    private Map<Integer, Integer> getPointMap() {
        return this.pointMap;
    }

    public static Map<Integer, Integer> mapGetter(int i) {
        return new HashMap<Integer, Integer>(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkillPoints that = (SkillPoints)o;
        return this.totalPoints == that.totalPoints && Objects.equals(this.pointMap, that.pointMap);
    }

    public int hashCode() {
        return Objects.hash(this.pointMap, this.totalPoints);
    }
}

