/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;

public final class EffectNode
extends SkillDataNode
implements ItemStackNode {
    public static final Codec<EffectNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText())), (App)MobEffectInstance.CODEC.listOf().fieldOf("effects").forGetter(EffectNode::getEffects)).apply((Applicative)instance, EffectNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EffectNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getLimit, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), (StreamCodec)MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), EffectNode::getEffects, EffectNode::new);
    private final List<MobEffectInstance> effects;

    public EffectNode(int id, String name, String description, int limit, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText, MobEffectInstance effect) {
        this(id, name, description, limit, requirements, skillSubText, List.of(effect));
    }

    public EffectNode(int id, String name, String description, int limit, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText, List<MobEffectInstance> effects) {
        super(id, name, description, limit, (ResourceLocation)null, requirements, (SkillSubText)skillSubText.orElse(null));
        this.effects = effects;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.EFFECT;
    }

    @Override
    public void processNode(SkillData skillData, ItemStack stack, int pointsToSpend, RegistryAccess registryAccess) {
        Consumable consumable = (Consumable)stack.get(net.minecraft.core.component.DataComponents.CONSUMABLE);
        if (consumable != null) {
            stack.set(net.minecraft.core.component.DataComponents.CONSUMABLE, (Object)this.withEffects(consumable, this.effects));
        } else {
            ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>((Collection)stack.getOrDefault(DataComponents.EFFECTS, Collections.emptyList()));
            List<MobEffectInstance> newEffects = this.addEffects(instances, new ArrayList<MobEffectInstance>(this.effects));
            stack.set(DataComponents.EFFECTS, newEffects);
        }
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    private Consumable withEffects(Consumable c, List<MobEffectInstance> effects) {
        ArrayList<Object> consumeEffects = new ArrayList<Object>();
        boolean foundConsumeEffect = false;
        for (ConsumeEffect consumeEffect : c.onConsumeEffects()) {
            if (consumeEffect instanceof ApplyStatusEffectsConsumeEffect) {
                ApplyStatusEffectsConsumeEffect applyStatusEffect = (ApplyStatusEffectsConsumeEffect)consumeEffect;
                foundConsumeEffect = true;
                ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
                for (MobEffectInstance newEffect : effects) {
                    boolean found = false;
                    for (MobEffectInstance existingEffect : applyStatusEffect.effects()) {
                        if (existingEffect.getEffect().equals((Object)newEffect.getEffect())) {
                            newEffects.add(this.combine(existingEffect, newEffect));
                            found = true;
                            break;
                        }
                        newEffects.add(existingEffect);
                    }
                    if (found) continue;
                    newEffects.add(newEffect);
                }
                consumeEffects.add(new ApplyStatusEffectsConsumeEffect(newEffects));
                continue;
            }
            consumeEffects.add(consumeEffect);
        }
        if (!foundConsumeEffect) {
            consumeEffects.add(new ApplyStatusEffectsConsumeEffect(effects));
        }
        return new Consumable(c.consumeSeconds(), c.animation(), c.sound(), c.hasConsumeParticles(), consumeEffects);
    }

    private List<MobEffectInstance> addEffects(List<MobEffectInstance> initialEffects, List<MobEffectInstance> newEffects) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(initialEffects);
        for (MobEffectInstance initialEffect : initialEffects) {
            boolean matched = false;
            for (int i = 0; i < newEffects.size(); ++i) {
                MobEffectInstance newEffect = newEffects.get(i);
                if (!initialEffect.getEffect().equals((Object)newEffect.getEffect())) continue;
                effects.add(this.combine(initialEffect, newEffect));
                newEffects.remove(i);
                matched = true;
                break;
            }
            if (matched) continue;
            effects.add(initialEffect);
        }
        effects.addAll(newEffects);
        return effects;
    }

    private MobEffectInstance combine(MobEffectInstance effect1, MobEffectInstance effect2) {
        return new MobEffectInstance(effect1.getEffect(), effect1.getDuration() + effect2.getDuration(), effect1.getAmplifier(), effect1.isAmbient(), effect1.isVisible(), effect1.showIcon());
    }
}

