/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class EnchantmentNode
extends SkillDataNode
implements ItemStackNode {
    public static final Codec<EnchantmentNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)ResourceLocation.CODEC.fieldOf("enchantment").forGetter(EnchantmentNode::getEnchantment), (App)Codec.INT.fieldOf("level").forGetter(EnchantmentNode::getLevel), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText()))).apply((Applicative)instance, EnchantmentNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ResourceLocation.STREAM_CODEC, EnchantmentNode::getEnchantment, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentNode::getLevel, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), EnchantmentNode::new);
    public static final Map<ResourceKey<Enchantment>, DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>>> TOGGLE_ENCHANTMENTS = Map.of(Enchantments.FROST_WALKER, DataComponents.FROST_WALKER);
    private final ResourceLocation enchantment;
    private final int level;

    public EnchantmentNode(int id, String name, String description, ResourceLocation enchantment, int level, List<SkillDataRequirement> requirements, Optional<SkillSubText> subText) {
        super(id, name, description, 1, List.of(enchantment), requirements, (SkillSubText)subText.orElse(null));
        this.enchantment = enchantment;
        this.level = level;
    }

    public ResourceLocation getEnchantment() {
        return this.enchantment;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.ENCHANTMENT;
    }

    @Override
    public void processNode(SkillData skillData, ItemStack stack, int pointsToSpend, RegistryAccess registryAccess) {
        Registry enchantmentRegistry = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        for (ResourceLocation key : this.getKeys()) {
            Optional enchantmentOptional = enchantmentRegistry.get(key);
            if (!enchantmentOptional.isPresent()) continue;
            if (key.equals((Object)Enchantments.SILK_TOUCH.location())) {
                stack.set(DataComponents.SILK_TOUCH_BONUS, (Object)true);
                if (EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FORTUNE)) {
                    return;
                }
            } else if (key.equals((Object)Enchantments.FORTUNE.location())) {
                stack.set(DataComponents.FORTUNE_BONUS, (Object)this.level);
                if (EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH)) {
                    return;
                }
            } else if (TOGGLE_ENCHANTMENTS.containsKey(((Holder.Reference)enchantmentOptional.get()).getKey())) {
                stack.set((Supplier)TOGGLE_ENCHANTMENTS.get(((Holder.Reference)enchantmentOptional.get()).getKey()), (Object)true);
            }
            enchantmentOptional.ifPresent(enchantmentReference -> stack.enchant((Holder)enchantmentReference, this.level));
        }
    }
}

