/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public final class FoodDataComponentNode
extends SkillDataNode
implements ItemStackNode {
    public static final Codec<FoodDataComponentNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)FoodProperties.DIRECT_CODEC.fieldOf("value").forGetter(FoodDataComponentNode::getValue), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText()))).apply((Applicative)instance, FoodDataComponentNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodDataComponentNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getLimit, (StreamCodec)FoodProperties.DIRECT_STREAM_CODEC, FoodDataComponentNode::getValue, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), FoodDataComponentNode::new);
    private final FoodProperties value;

    public FoodDataComponentNode(int id, String name, String description, int limit, FoodProperties value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        super(id, name, description, limit, (ResourceLocation)null, requirements, (SkillSubText)skillSubText.orElse(null));
        this.value = value;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.FOOD_DATA_COMPONENT;
    }

    @Override
    public void processNode(SkillData skillData, ItemStack stack, int pointsToSpend, RegistryAccess registryAccess) {
        FoodProperties existingProperties = (FoodProperties)stack.getOrDefault(DataComponents.FOOD, (Object)new FoodProperties(0, 0.0f, false));
        stack.set(DataComponents.FOOD, (Object)FoodDataComponentNode.add(existingProperties, FoodDataComponentNode.mult(this.value, pointsToSpend)));
    }

    public FoodProperties getValue() {
        return this.value;
    }

    private static FoodProperties add(FoodProperties p1, FoodProperties p2) {
        return new FoodProperties(p1.nutrition() + p2.nutrition(), p1.saturation() + p2.saturation(), p1.canAlwaysEat() || p2.canAlwaysEat());
    }

    private static FoodProperties mult(FoodProperties p, int i) {
        return new FoodProperties(p.nutrition() * i, p.saturation() * (float)i, p.canAlwaysEat());
    }
}

