/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.utils.CodecUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class SkillDataNode {
    private final int id;
    private final String name;
    private final String description;
    private final int limit;
    private final List<SkillDataRequirement> requirements;
    private final List<ResourceLocation> keys;
    private SkillSubText skillSubText;
    public static Codec<SkillDataNode> CODEC = ResourceLocation.CODEC.xmap(SkillNodeType::fromResourceLocation, SkillNodeType::resourceLocation).dispatch(SkillDataNode::getSkillNodeType, SkillNodeType::codec);
    public static StreamCodec<RegistryFriendlyByteBuf, SkillDataNode> STREAM_CODEC = CodecUtils.RESOURCE_LOCATION_STREAM_CODEC.map(SkillNodeType::fromResourceLocation, SkillNodeType::resourceLocation).dispatch(SkillDataNode::getSkillNodeType, SkillNodeType::streamCodec);

    public SkillDataNode(int id, String name, String description, int limit, ResourceLocation key, List<SkillDataRequirement> requirements, SkillSubText skillSubText) {
        this(id, name, description, limit, key == null ? List.of() : List.of(key), requirements, skillSubText);
    }

    public SkillDataNode(int id, String name, String description, int limit, List<ResourceLocation> keys, List<SkillDataRequirement> requirements, SkillSubText skillSubText) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.limit = limit;
        this.keys = keys;
        this.requirements = requirements;
        this.skillSubText = skillSubText;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<SkillDataRequirement> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(SkillDataRequirement requirement) {
        this.requirements.add(requirement);
    }

    public List<ResourceLocation> getKeys() {
        return this.keys;
    }

    public SkillSubText getSkillSubText() {
        return this.skillSubText;
    }

    public void setSubtext(SkillSubText subtext) {
        this.skillSubText = subtext;
    }

    public boolean canLevel(SkillPoints points, Player player) {
        for (SkillDataRequirement requirement : this.requirements) {
            if (requirement.canLevel(points, player)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SkillDataNode{id=" + this.id + ", name='" + this.name + "', description='" + this.description + "', limit=" + this.limit + ", requirements=" + String.valueOf(this.requirements) + ", key='" + (this.keys != null ? this.keys.stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")) : "") + "'}";
    }

    public abstract SkillNodeType getSkillNodeType();
}

