/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.willyelton.crystal_tools.common.levelable.skill.node.AttributeNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.BlockEntityNbtNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.DataComponentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.EffectNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.EnchantmentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.FoodDataComponentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public enum SkillNodeType {
    ATTRIBUTE(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"attribute"), AttributeNode.CODEC, AttributeNode.STREAM_CODEC),
    DATA_COMPONENT(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"data_component"), DataComponentNode.CODEC, DataComponentNode.STREAM_CODEC),
    ENCHANTMENT(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"enchantment"), EnchantmentNode.CODEC, EnchantmentNode.STREAM_CODEC),
    FOOD_DATA_COMPONENT(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"food_data_component"), FoodDataComponentNode.CODEC, FoodDataComponentNode.STREAM_CODEC),
    EFFECT(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"effect"), EffectNode.CODEC, EffectNode.STREAM_CODEC),
    BLOCK_ENTITY_NBT(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"block_entity_nbt"), BlockEntityNbtNode.CODEC, BlockEntityNbtNode.STREAM_CODEC);

    private final ResourceLocation type;
    private final MapCodec<? extends SkillDataNode> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, ? extends SkillDataNode> streamCodec;

    private SkillNodeType(ResourceLocation type, Codec<? extends SkillDataNode> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends SkillDataNode> streamCodec) {
        this.type = type;
        this.codec = codec.fieldOf("node");
        this.streamCodec = streamCodec;
    }

    public MapCodec<? extends SkillDataNode> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends SkillDataNode> streamCodec() {
        return this.streamCodec;
    }

    public ResourceLocation resourceLocation() {
        return this.type;
    }

    public static SkillNodeType fromResourceLocation(ResourceLocation type) {
        for (SkillNodeType skillNodeType : SkillNodeType.values()) {
            if (!skillNodeType.type.equals((Object)type)) continue;
            return skillNodeType;
        }
        throw new IllegalArgumentException("Invalid skill node type: " + String.valueOf(type));
    }
}

