/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.tool.DiggerLevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.UseMode;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import dev.willyelton.crystal_tools.utils.StringUtils;
import dev.willyelton.crystal_tools.utils.ToolUseUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;

public class AIOLevelableTool
extends DiggerLevelableTool {
    public static final Set<ItemAbility> AIOT_ACTIONS = new HashSet<ItemAbility>();

    public AIOLevelableTool(Item.Properties properties) {
        super(properties.tool(CRYSTAL, CrystalToolsTags.MINABLE_WITH_AIOT, 3.0f, -2.4f, 5.0f));
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_AXE_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_HOE_ACTIONS);
        AIOT_ACTIONS.addAll(ItemAbilities.DEFAULT_SHOVEL_ACTIONS);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        UseMode mode = (UseMode)((Object)stack.getOrDefault(DataComponents.USE_MODE, (Object)UseMode.HOE));
        switch (mode) {
            case HOE: {
                return ToolUseUtils.useOnHoe3x3(context);
            }
            case SHOVEL: {
                return ToolUseUtils.useOnShovel3x3(context);
            }
            case AXE: {
                return ToolUseUtils.useOnAxeVeinStrip(context, this);
            }
            case TORCH: {
                return ToolUseUtils.useOnTorch(context);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return AIOT_ACTIONS.contains(itemAbility) || (Boolean)stack.getOrDefault(DataComponents.SHEAR, (Object)false) != false && ItemAbilities.DEFAULT_SHEARS_ACTIONS.contains(itemAbility);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.getDestroySpeed(null, null) != -1.0f;
    }

    @Override
    public boolean canVeinMin(ItemStack stack, BlockState blockState) {
        return blockState.is(Tags.Blocks.ORES) || blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> components, TooltipFlag flag) {
        String toolTip = "\u00a79Use Mode: " + StringUtils.capitalize(((Serializable)stack.getOrDefault(DataComponents.USE_MODE, (Object)"hoe")).toString().toLowerCase(Locale.ROOT));
        if (RegisterKeyBindingsEvent.MODE_SWITCH != null) {
            toolTip = toolTip + " (alt + " + RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString() + " to change)";
        }
        components.accept((Component)Component.literal((String)toolTip));
    }
}

