/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class CrystalRocket
extends LevelableTool {
    public CrystalRocket(Item.Properties properties) {
        super(properties.durability(100));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        return this.use(player.getItemInHand(hand), level, player, hand);
    }

    public InteractionResult use(ItemStack stack, Level level, Player player, InteractionHand hand) {
        if (ToolUtils.isBroken(stack)) {
            return InteractionResult.PASS;
        }
        if (player.isFallFlying()) {
            Levelable levelable;
            if (!level.isClientSide()) {
                int flightTime = (Integer)stack.getOrDefault(DataComponents.FLIGHT_TIME, (Object)1);
                Fireworks fireworks = new Fireworks(flightTime, Collections.emptyList());
                stack.set(net.minecraft.core.component.DataComponents.FIREWORKS, (Object)fireworks);
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, stack, (LivingEntity)player);
                level.addFreshEntity((Entity)fireworkrocketentity);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if ((levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) != null) {
                levelable.addExp(level, player.getOnPos(), (LivingEntity)player);
            }
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        this.levelableInventoryTick(itemStack, (Level)level, entity, slot, (Double)CrystalToolsConfig.ROCKET_REPAIR_MODIFIER.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.accept((Component)Component.literal((String)String.format("Press %s while this is in your inventory to automatically use!", RegisterKeyBindingsEvent.TRIGGER_ROCKET.getKey().getDisplayName().getString())));
        super.appendHoverText(stack, context, display, tooltipComponents, flag);
    }
}

