/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.EntityTargeter;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class CrystalShield
extends ShieldItem
implements LevelableItem,
EntityTargeter {
    public CrystalShield(Item.Properties properties) {
        super(properties.durability(1000).component(net.minecraft.core.component.DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).component(net.minecraft.core.component.DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK))).fireResistant().repairable(CrystalToolsTags.REPAIRS_CRYSTAL));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        this.refreshTarget(stack, level, (LivingEntity)player);
        return super.use(level, player, hand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.refreshTarget(stack, level, livingEntity);
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.clearTarget(stack, entity.level());
        super.onStopUsing(stack, entity, count);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> components, TooltipFlag flag) {
        int totemSlots = (Integer)stack.getOrDefault(DataComponents.TOTEM_SLOTS, (Object)0);
        if (totemSlots > 0) {
            components.accept((Component)Component.literal((String)String.format("\u00a72%d/%d Totems of Undying", stack.getOrDefault(DataComponents.FILLED_TOTEM_SLOTS, (Object)0), totemSlots)));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        if (durability - amount <= 0) {
            return 0;
        }
        return amount;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.getDamageValue() * 13.0f / (float)itemStack.getMaxDamage());
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.getMaxDamage() - (float)itemStack.getDamageValue()) / (float)itemStack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        this.levelableInventoryTick(stack, (Level)level, entity, slot, 1.0);
    }
}

