/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.entity.CrystalTridentEntity;
import dev.willyelton.crystal_tools.common.events.LevelTickEvent;
import dev.willyelton.crystal_tools.common.levelable.EntityTargeter;
import dev.willyelton.crystal_tools.common.levelable.tool.SwordLevelableTool;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class CrystalTrident
extends SwordLevelableTool
implements EntityTargeter {
    public CrystalTrident(Item.Properties properties) {
        super(properties.attributes(TridentItem.createAttributes()).durability(CRYSTAL.durability()).component(net.minecraft.core.component.DataComponents.TOOL, (Object)TridentItem.createToolProperties()).component(net.minecraft.core.component.DataComponents.WEAPON, (Object)new Weapon(1)));
    }

    @Override
    public float getDestroySpeed(ItemStack pStack, BlockState pState) {
        return 1.0f;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return false;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return false;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
            return InteractionResult.FAIL;
        }
        if (this.riptideEnabled(stack) && !this.canRiptide(stack, player)) {
            return InteractionResult.FAIL;
        }
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int timeUsed = this.getUseDuration(stack, entityLiving) - timeLeft;
            if (timeUsed >= 10) {
                int riptideLevel = (Integer)stack.getOrDefault(DataComponents.RIPTIDE, (Object)0);
                if (!level.isClientSide()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, entityLiving.getUsedItemHand().asEquipmentSlot());
                    if (!this.riptideEnabled(stack)) {
                        CrystalTridentEntity tridentEntity = new CrystalTridentEntity(level, (LivingEntity)player, stack);
                        float velocity = 2.5f + ((Float)stack.getOrDefault(DataComponents.PROJECTILE_SPEED, (Object)Float.valueOf(0.0f))).floatValue() * 0.5f;
                        tridentEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, 1.0f);
                        if (player.getAbilities().instabuild) {
                            tridentEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)tridentEntity);
                        int target = (Integer)stack.getOrDefault(DataComponents.ENTITY_TARGET, (Object)-1);
                        if (target != -1) {
                            LevelTickEvent.startTracking(level, tridentEntity.getId(), target, velocity / 2.0f);
                        }
                        level.playSound(null, (Entity)tridentEntity, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            player.getInventory().removeItem(stack);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (this.canRiptide(stack, player)) {
                    float playerYRot = player.getYRot();
                    float playerXRot = player.getXRot();
                    float playerPushX = -Mth.sin((float)(playerYRot * ((float)Math.PI / 180))) * Mth.cos((float)(playerXRot * ((float)Math.PI / 180)));
                    float playerPushY = -Mth.sin((float)(playerXRot * ((float)Math.PI / 180)));
                    float playerPushZ = Mth.cos((float)(playerYRot * ((float)Math.PI / 180))) * Mth.cos((float)(playerXRot * ((float)Math.PI / 180)));
                    float playerSpeed = Mth.sqrt((float)(playerPushX * playerPushX + playerPushY * playerPushY + playerPushZ * playerPushZ));
                    float playerPushMagnitude = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
                    player.push((double)(playerPushX *= playerPushMagnitude / playerSpeed), (double)(playerPushY *= playerPushMagnitude / playerSpeed), (double)(playerPushZ *= playerPushMagnitude / playerSpeed));
                    player.startAutoSpinAttack(20, 8.0f, stack);
                    if (player.onGround()) {
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideLevel >= 3 ? (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value() : (riptideLevel == 2 ? (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_2.value() : (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_1.value());
                    level.playSound(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return true;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.refreshTarget(stack, level, livingEntity);
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.clearTarget(stack, entity.level());
        super.onStopUsing(stack, entity, count);
    }

    public boolean mineBlock(@NotNull ItemStack tool, Level level, @NotNull BlockState blockState, @NotNull BlockPos blockPos, @NotNull LivingEntity entity) {
        return false;
    }

    private boolean canRiptide(ItemStack stack, Player player) {
        if (((Boolean)stack.getOrDefault(DataComponents.RIPTIDE_DISABLED, (Object)false)).booleanValue()) {
            return false;
        }
        if (((Boolean)stack.getOrDefault(DataComponents.ALWAYS_RIPTIDE, (Object)false)).booleanValue()) {
            return true;
        }
        return (Integer)stack.getOrDefault(DataComponents.RIPTIDE, (Object)0) > 0 && player.isInWaterOrRain();
    }

    private boolean riptideEnabled(ItemStack stack) {
        if (((Boolean)stack.getOrDefault(DataComponents.RIPTIDE_DISABLED, (Object)false)).booleanValue()) {
            return false;
        }
        if (((Boolean)stack.getOrDefault(DataComponents.ALWAYS_RIPTIDE, (Object)false)).booleanValue()) {
            return true;
        }
        return (Integer)stack.getOrDefault(DataComponents.RIPTIDE, (Object)0) > 0;
    }
}

