/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.node.BlockEntityNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.network.data.BlockSkillPayload;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BlockSkillHandler {
    public static final BlockSkillHandler INSTANCE = new BlockSkillHandler();

    public void handle(BlockSkillPayload payload, IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(payload.pos());
        if (blockEntity instanceof LevelableBlockEntity) {
            SkillData data;
            SkillDataNode node;
            Optional dataOptional;
            LevelableBlockEntity levelableBlockEntity = (LevelableBlockEntity)blockEntity;
            Optional skillDataOptional = level.registryAccess().lookup(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_BLOCKS);
            if (skillDataOptional.isPresent() && (dataOptional = ((Registry)skillDataOptional.get()).get(payload.key())).isPresent() && (node = (data = (SkillData)((Holder.Reference)dataOptional.get()).value()).getNodeMap().get(payload.nodeId())) instanceof BlockEntityNode) {
                BlockEntityNode blockEntityNode = (BlockEntityNode)((Object)node);
                int skillPoints = levelableBlockEntity.getSkillPoints();
                int pointsToAdd = Math.min(skillPoints, payload.pointsToSpend());
                levelableBlockEntity.addSkillPoints(-pointsToAdd);
                blockEntityNode.processNode(data, levelableBlockEntity, pointsToAdd, level.registryAccess());
            }
        }
    }
}

