/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.network.data.PointsFromXpPayload;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import dev.willyelton.crystal_tools.utils.XpUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public class PointsFromXpHandler {
    public static PointsFromXpHandler INSTANCE = new PointsFromXpHandler();

    public void handle(PointsFromXpPayload payload, IPayloadContext context) {
        Player player = context.player();
        int totalPoints = this.getTotalPoints(payload.item(), player);
        int xpCost = XpUtils.getXpCost(payload.points(), totalPoints);
        if (XpUtils.getPlayerTotalXp(player) >= (long)xpCost) {
            player.giveExperiencePoints(-xpCost);
            this.addPoints(payload.item(), player, payload.points());
        }
    }

    private int getTotalPoints(boolean item, Player player) {
        if (item) {
            ItemStack heldTool = ItemStackUtils.getHeldLevelableTool(player);
            int spentPoints = ((SkillPoints)heldTool.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).getTotalPoints();
            int unspentPoints = (Integer)heldTool.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
            return spentPoints + unspentPoints;
        }
        LevelableBlockEntity blockEntity = this.getBlockEntity(player);
        if (blockEntity != null) {
            return blockEntity.getSkillPoints() + blockEntity.getPoints().getTotalPoints();
        }
        return -1;
    }

    private void addPoints(boolean item, Player player, int points) {
        if (item) {
            ItemStack heldTool = ItemStackUtils.getHeldLevelableTool(player);
            if (!heldTool.isEmpty()) {
                DataComponents.addToComponent(heldTool, DataComponents.SKILL_POINTS, points);
            }
        } else {
            LevelableBlockEntity blockEntity = this.getBlockEntity(player);
            if (blockEntity != null) {
                blockEntity.addSkillPoints(points);
            }
        }
    }

    @Nullable
    private LevelableBlockEntity getBlockEntity(Player player) {
        AbstractContainerMenu container = player.containerMenu;
        if (container instanceof LevelableContainerMenu) {
            LevelableContainerMenu levelableContainerMenu = (LevelableContainerMenu)container;
            return levelableContainerMenu.getBlockEntity();
        }
        return null;
    }
}

