/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.datagen.MinecraftItemSkillTrees;
import dev.willyelton.crystal_tools.utils.StringUtils;
import dev.willyelton.crystal_tools.utils.constants.SkillConstants;
import dev.willyelton.crystal_tools.utils.constants.SkillTreeDescriptions;
import dev.willyelton.crystal_tools.utils.constants.SkillTreeTitles;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.NeoForgeMod;

public class CrystalToolsItemSkillTrees {
    private final BootstrapContext<SkillData> context;

    public static void register(BootstrapContext<SkillData> context) {
        CrystalToolsItemSkillTrees skillTrees = new CrystalToolsItemSkillTrees(context);
        skillTrees.registerSkillTrees();
        MinecraftItemSkillTrees.registerSkillTrees(context);
    }

    public CrystalToolsItemSkillTrees(BootstrapContext<SkillData> context) {
        this.context = context;
    }

    public void registerSkillTrees() {
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_PICKAXE.getId()), (Object)this.basicMiningTool("Pickaxe"));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_HOE.getId()), (Object)this.basicMiningTool("Hoe"));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_SHOVEL.getId()), (Object)this.basicMiningTool("Shovel"));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_AXE.getId()), (Object)this.basicMiningTool("Axe"));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_AIOT.getId()), (Object)this.aiot());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_FISHING_ROD.getId()), (Object)this.fishingRod());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_SHIELD.getId()), (Object)this.shield());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_SWORD.getId()), (Object)this.sword());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_BOW.getId()), (Object)this.bow());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_TRIDENT.getId()), (Object)this.trident());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_APPLE.getId()), (Object)this.food("Apple"));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_HELMET.getId()), (Object)this.helmet());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_CHESTPLATE.getId()), (Object)this.chestplate(false));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_LEGGINGS.getId()), (Object)this.leggings());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_BOOTS.getId()), (Object)this.boots());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_ELYTRA.getId()), (Object)this.chestplate(true));
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_ROCKET.getId()), (Object)this.rocket());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_BACKPACK.getId()), (Object)this.backpack());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.CRYSTAL_MAGNET.getId()), (Object)this.magnet());
        this.context.register(ResourceKey.create(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, (ResourceLocation)ModRegistration.PORTABLE_GENERATOR.getId()), (Object)this.portableGenerator());
    }

    private SkillData basicMiningTool(String name) {
        SkillTreeDescriptions desc = new SkillTreeDescriptions(name);
        boolean axe = name.equals("Axe");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().attributeNode(0, SkillTreeTitles.miningSpeed(1), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).dataComponentNode(1, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).tier().attributeNode(2, SkillTreeTitles.miningSpeed(2), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(0).dataComponentNode(3, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(1).dataComponentNode(4, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().tier().attributeNode(5, SkillTreeTitles.miningSpeed(3), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(2).dataComponentNode(6, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(3).attributeNode(7, SkillTreeTitles.reach(1), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE)), 1.0f).previousTierOrRequirements().tier().enchantmentNode(8, "Silk Touch", desc.silkTouch(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, 1).previousTierOrRequirements().notNodeRequirement(9, 22).enchantmentNode(9, SkillTreeTitles.fortune(3), desc.fortune(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, 3).previousTierOrRequirements().notNodeRequirement(8, 22).dataComponentNode(10, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().nodeRequirement(4).optional(axe).dataComponentNode(30, "Leaf Miner", desc.leafMiner(), DataComponents.LEAF_MINE.getId(), 1.0f).previousTierOrRequirements().endOptional().tier().attributeNode(11, SkillTreeTitles.miningSpeed(4), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(5).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(6).previousTierOrRequirements().tier().attributeNode(13, SkillTreeTitles.miningSpeed(5), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(11).dataComponentNode(14, SkillTreeTitles.durability(5), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(12).attributeNode(15, SkillTreeTitles.reach(2), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE)), 1.0f).nodeRequirement(7).previousTierOrRequirements().dataComponentNode(16, "Auto Pickup", desc.autoPickup(), DataComponents.AUTO_PICKUP.getId(), 1.0f).previousTierOrRequirements().tier().infiniteDataComponentNode(17, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(18, "3x3 Mining", desc.mining3x3(), DataComponents.HAS_3x3.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(19, !axe ? "Vein Mining" : "Tree Chopper", desc.veinMining(axe), DataComponents.VEIN_MINER.getId(), 1.0f).previousTierOrRequirements().subText("+1 block range per level", "#ABABAB").dataComponentNode(20, "Auto Smelting", desc.autoSmelting(), DataComponents.AUTO_SMELT.getId(), 1.0f).previousTierOrRequirements().optional(name.equals("Hoe")).dataComponentNode(30, "Shears", desc.shears(), DataComponents.SHEAR.getId(), 1.0f).itemRequirement(Items.SHEARS).previousTierOrRequirements().endOptional().tier().optional(name.equals("Pickaxe")).dataComponentNode(21, "Torch", desc.torch(), DataComponents.TORCH.getId(), 1.0f).previousTierOrRequirements().subText("Uses 10 durability", "#ABABAB").endOptional().dataComponentNode(22, "Mode Switch", desc.mineMode(), DataComponents.MINE_MODE.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(23, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().nodeRequirement(10).attributeNode(24, SkillTreeTitles.reach(3), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE)), 1.0f).nodeRequirement(15).previousTierOrRequirements().tier().infiniteAttributeNode(25, SkillTreeTitles.miningSpeed(0), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 0.2f).nodeRequirement(13).previousTierOrRequirements().infiniteDataComponentNode(26, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(14).previousTierOrRequirements().dataComponentNode(27, SkillTreeTitles.unbreaking(0), desc.unbreaking(), SkillConstants.DURABILITY, 50.0f, 70).nodeRequirement(23).previousTierOrRequirements().infiniteAttributeNode(28, SkillTreeTitles.reach(0), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE)), 0.1f).nodeRequirement(24).previousTierOrRequirements().tier().enchantmentNode(29, SkillTreeTitles.fortune(5), desc.fortune(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, 5).nodeRequirement(9, 25, 26, 27, 28).build();
    }

    private SkillData sword() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Sword");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().attributeNode(0, SkillTreeTitles.attackDamage(1), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).attributeNode(1, SkillTreeTitles.attackSpeed(1), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).dataComponentNode(2, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).tier().attributeNode(3, SkillTreeTitles.attackDamage(2), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(0).attributeNode(4, SkillTreeTitles.attackSpeed(2), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(1).dataComponentNode(5, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(2).tier().enchantmentNode(6, desc, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, 2).previousTierOrRequirements().attributeNode(7, SkillTreeTitles.knockbackResistance(1), desc.knockbackResistance(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 0.1f).previousTierOrRequirements().attributeNode(8, SkillTreeTitles.knockback(1), desc.knockback(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 1.0f).previousTierOrRequirements().dataComponentNode(9, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.beheading(1), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).previousTierOrRequirements().tier().attributeNode(11, SkillTreeTitles.attackDamage(3), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(3).previousTierOrRequirements().attributeNode(12, SkillTreeTitles.attackSpeed(3), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(4).previousTierOrRequirements().dataComponentNode(13, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(5).previousTierOrRequirements().attributeNode(14, SkillTreeTitles.reach(1), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).previousTierOrRequirements().dataComponentNode(15, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(16, SkillTreeTitles.lifesteal(1), desc.lifesteal(), DataComponents.LIFESTEAL.getId(), 2.0f).previousTierOrRequirements().attributeNode(17, SkillTreeTitles.knockbackResistance(2), desc.knockbackResistance(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 0.1f).nodeRequirement(7).previousTierOrRequirements().attributeNode(18, SkillTreeTitles.knockback(2), desc.knockback(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 1.0f).nodeRequirement(8).previousTierOrRequirements().dataComponentNode(19, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(9).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.beheading(2), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(10).previousTierOrRequirements().tier().attributeNode(21, SkillTreeTitles.attackDamage(4), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(11).previousTierOrRequirements().attributeNode(22, SkillTreeTitles.attackSpeed(4), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(12).previousTierOrRequirements().dataComponentNode(23, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(13).previousTierOrRequirements().attributeNode(24, SkillTreeTitles.reach(2), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(14).previousTierOrRequirements().dataComponentNode(25, SkillTreeTitles.capturing(2), desc.capturing(), DataComponents.CAPTURING.getId(), 1.0f).nodeRequirement(15).previousTierOrRequirements().tier().enchantmentNode(26, desc, (ResourceKey<Enchantment>)Enchantments.LOOTING, 3).previousTierOrRequirements().dataComponentNode(27, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().dataComponentNode(28, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(19).previousTierOrRequirements().dataComponentNode(29, SkillTreeTitles.beheading(3), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(20).previousTierOrRequirements().enchantmentNode(30, desc, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, 3).previousTierOrRequirements().tier().attributeNode(31, SkillTreeTitles.attackDamage(5), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(21).previousTierOrRequirements().attributeNode(32, SkillTreeTitles.attackSpeed(5), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(22).previousTierOrRequirements().dataComponentNode(33, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(23).previousTierOrRequirements().attributeNode(34, SkillTreeTitles.reach(3), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(24).previousTierOrRequirements().dataComponentNode(35, SkillTreeTitles.capturing(3), desc.capturing(), DataComponents.CAPTURING.getId(), 1.0f).nodeRequirement(25).previousTierOrRequirements().tier().infiniteAttributeNode(36, SkillTreeTitles.attackDamage(0), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 0.25f).nodeRequirement(31).infiniteDataComponentNode(37, SkillTreeTitles.attackSpeed(0), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 0.25f).nodeRequirement(32).infiniteDataComponentNode(38, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(33).dataComponentNode(39, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f, 70).nodeRequirement(28).previousTierOrRequirements().infiniteAttributeNode(40, SkillTreeTitles.reach(0), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 0.1f).nodeRequirement(34).tier().enchantmentNode(41, desc, (ResourceKey<Enchantment>)Enchantments.LOOTING, 5).previousTierAndRequirements(new int[0]).build();
    }

    private SkillData food(String name) {
        SkillTreeDescriptions desc = new SkillTreeDescriptions(name);
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().nutrition(0, 1, 2, desc.nutrition()).saturation(1, 1, 0.4f, desc.saturation()).dataComponentNode(2, SkillTreeTitles.eatSpeed(1), desc.eatSpeed(), DataComponents.EAT_SPEED_BONUS.getId(), 6.0f).dataComponentNode(3, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 25.0f).tier().nutrition(4, 2, 2, desc.nutrition()).nodeRequirement(0).saturation(5, 2, 0.4f, desc.saturation()).nodeRequirement(1).dataComponentNode(6, SkillTreeTitles.eatSpeed(2), desc.eatSpeed(), DataComponents.EAT_SPEED_BONUS.getId(), 6.0f).nodeRequirement(2).dataComponentNode(7, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 25.0f).nodeRequirement(3).tier().infiniteDataComponentNode(8, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements().alwaysEat(9, desc.alwaysEat()).previousTierOrRequirements().tier().nutrition(10, 3, 2, desc.nutrition()).nodeRequirement(4).saturation(11, 3, 0.4f, desc.saturation()).nodeRequirement(5).dataComponentNode(12, SkillTreeTitles.eatSpeed(3), desc.eatSpeed(), DataComponents.EAT_SPEED_BONUS.getId(), 6.0f).nodeRequirement(6).dataComponentNode(13, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 25.0f).nodeRequirement(7).tier().nutrition(14, 4, 2, desc.nutrition()).nodeRequirement(10).saturation(15, 4, 0.4f, desc.saturation()).nodeRequirement(11).dataComponentNode(16, SkillTreeTitles.eatSpeed(4), desc.eatSpeed(), DataComponents.EAT_SPEED_BONUS.getId(), 6.0f).nodeRequirement(12).dataComponentNode(17, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 25.0f).nodeRequirement(13).tier().nutrition(18, 0, 1, desc.nutrition(), 0).nodeRequirement(14).saturation(19, 0, 0.1f, desc.saturation(), 0).nodeRequirement(15).dataComponentNode(20, SkillTreeTitles.eatSpeed(0), desc.eatSpeed(), DataComponents.EAT_SPEED_BONUS.getId(), 1.0f, 7).nodeRequirement(16).infiniteDataComponentNode(21, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 10.0f).nodeRequirement(17).tier().effect(22, desc, new MobEffectInstance(MobEffects.SPEED, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.SUGAR, Items.GLOWSTONE_DUST).effect(23, desc, new MobEffectInstance(MobEffects.HASTE, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.GOLD_INGOT, Items.GLOWSTONE_DUST).effect(24, desc, new MobEffectInstance(MobEffects.STRENGTH, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.BLAZE_POWDER, Items.GLOWSTONE_DUST).effect(25, desc, new MobEffectInstance(MobEffects.JUMP_BOOST, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.RABBIT_FOOT, Items.GLOWSTONE_DUST).effect(26, desc, new MobEffectInstance(MobEffects.REGENERATION, 10, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.GHAST_TEAR, Items.GLOWSTONE_DUST).effect(27, desc, new MobEffectInstance(MobEffects.RESISTANCE, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.IRON_INGOT, Items.GLOWSTONE_DUST).effect(28, desc, new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.MAGMA_CREAM).effect(29, desc, new MobEffectInstance(MobEffects.WATER_BREATHING, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.PUFFERFISH).effect(30, desc, new MobEffectInstance(MobEffects.INVISIBILITY, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.GOLDEN_CARROT, Items.FERMENTED_SPIDER_EYE).effect(31, desc, new MobEffectInstance(MobEffects.NIGHT_VISION, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.GOLDEN_CARROT).effect(32, desc, new MobEffectInstance(MobEffects.ABSORPTION, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.GLISTERING_MELON_SLICE, Items.GLOWSTONE_DUST).effect(33, desc, new MobEffectInstance(MobEffects.SATURATION, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.COOKED_BEEF, Items.GLOWSTONE_DUST).effect(34, desc, new MobEffectInstance(MobEffects.SLOW_FALLING, 20, 1)).previousTierOrRequirements().itemRequirement(Items.NETHER_WART, Items.PHANTOM_MEMBRANE).build();
    }

    private SkillData helmet() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Helmet");
        SkillData.Builder builder = SkillData.builder(EquipmentSlot.HEAD);
        this.armorTier(builder, 0, -1, 1, desc);
        this.armorTier(builder, 4, 0, 2, desc);
        builder.tier().attributeNode(8, SkillTreeTitles.baseArmor(1), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).previousTierOrRequirements().attributeNode(9, SkillTreeTitles.toughness(1), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).previousTierOrRequirements().enchantmentNode(10, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY, 0), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY, 0)), (ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY, 1);
        this.armorTier(builder, 11, 4, 3, desc, true);
        builder.tier().attributeNode(15, SkillTreeTitles.baseArmor(2), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(8).previousTierOrRequirements().attributeNode(16, SkillTreeTitles.toughness(2), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).nodeRequirement(9).previousTierOrRequirements().enchantmentNode(17, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.RESPIRATION, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.RESPIRATION, 3)), (ResourceKey<Enchantment>)Enchantments.RESPIRATION, 3).previousTierOrRequirements().infiniteDataComponentNode(18, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements();
        this.armorTier(builder, 19, 11, 4, desc, true);
        builder.tier().attributeNode(23, SkillTreeTitles.baseArmor(3), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(15).previousTierOrRequirements().attributeNode(24, SkillTreeTitles.toughness(3), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.5f).nodeRequirement(16).previousTierOrRequirements().enchantmentNode(25, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3)), (ResourceKey<Enchantment>)Enchantments.THORNS, 3).previousTierOrRequirements().dataComponentNode(26, "Night Vision", desc.nightVision(), DataComponents.NIGHT_VISION.getId(), 1.0f).subText("Can be disabled with the mode switch key", "#ABABAB").previousTierOrRequirements();
        return builder.build();
    }

    private SkillData chestplate(boolean elytra) {
        SkillTreeDescriptions desc = new SkillTreeDescriptions(elytra ? "Elytra" : "Chestplate");
        SkillData.Builder builder = SkillData.builder(EquipmentSlot.CHEST);
        this.armorTier(builder, 0, -1, 1, desc);
        this.armorTier(builder, 4, 0, 2, desc);
        builder.tier().attributeNode(8, SkillTreeTitles.baseArmor(1), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).previousTierOrRequirements().attributeNode(9, SkillTreeTitles.toughness(1), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).previousTierOrRequirements().attributeNode(10, SkillTreeTitles.healthBonus(1), desc.healthBonus(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MAX_HEALTH), 2.0f).previousTierOrRequirements();
        if (elytra) {
            builder.dataComponentNode(28, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements();
        }
        this.armorTier(builder, 11, 4, 3, desc, true);
        builder.tier().attributeNode(15, SkillTreeTitles.baseArmor(2), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(8).previousTierOrRequirements().attributeNode(16, SkillTreeTitles.toughness(2), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).nodeRequirement(9).previousTierOrRequirements().attributeNode(17, SkillTreeTitles.healthBonus(2), desc.healthBonus(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MAX_HEALTH), 2.0f).nodeRequirement(10).previousTierOrRequirements().infiniteDataComponentNode(18, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements();
        if (elytra) {
            builder.dataComponentNode(29, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(28).previousTierOrRequirements();
        }
        this.armorTier(builder, 19, 11, 4, desc, true);
        builder.tier().attributeNode(23, SkillTreeTitles.baseArmor(3), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(15).previousTierOrRequirements().attributeNode(24, SkillTreeTitles.toughness(3), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.5f).nodeRequirement(16).previousTierOrRequirements().enchantmentNode(25, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3)), (ResourceKey<Enchantment>)Enchantments.THORNS, 3).previousTierOrRequirements().attributeNode(26, SkillTreeTitles.healthBonus(3), desc.healthBonus(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MAX_HEALTH), 4.0f).nodeRequirement(17).previousTierOrRequirements();
        if (elytra) {
            builder.dataComponentNode(30, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(29).previousTierOrRequirements();
        }
        if (elytra) {
            builder.tier().dataComponentNode(31, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).nodeRequirement(30).attributeNode(27, "Creative Flight", desc.creativeFlight(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)NeoForgeMod.CREATIVE_FLIGHT), 1.0f, 100, true).nodeRequirement(23, 24, 25, 26, 30);
        }
        return builder.build();
    }

    private SkillData leggings() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Leggings");
        SkillData.Builder builder = SkillData.builder(EquipmentSlot.LEGS);
        this.armorTier(builder, 0, -1, 1, desc);
        builder.enchantmentNode(4, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 1), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 1)), (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 1);
        this.armorTier(builder, 5, 0, 2, desc);
        builder.enchantmentNode(9, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 2), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 2)), (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 2).nodeRequirement(4).previousTierOrRequirements();
        builder.tier().attributeNode(10, SkillTreeTitles.baseArmor(1), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).previousTierOrRequirements().attributeNode(11, SkillTreeTitles.toughness(1), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).previousTierOrRequirements().attributeNode(12, SkillTreeTitles.moveSpeed(1), desc.moveSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MOVEMENT_SPEED), 1.0f).previousTierOrRequirements();
        this.armorTier(builder, 13, 5, 3, desc, true);
        builder.enchantmentNode(17, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 3)), (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 3).nodeRequirement(9).previousTierOrRequirements();
        builder.tier().attributeNode(18, SkillTreeTitles.baseArmor(2), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(10).previousTierOrRequirements().attributeNode(19, SkillTreeTitles.toughness(2), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).nodeRequirement(11).previousTierOrRequirements().attributeNode(20, SkillTreeTitles.moveSpeed(2), desc.moveSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MOVEMENT_SPEED), 1.0f).nodeRequirement(12).previousTierOrRequirements().infiniteDataComponentNode(21, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements();
        this.armorTier(builder, 22, 13, 4, desc, true);
        builder.enchantmentNode(26, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 4), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 4)), (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 4).nodeRequirement(17).previousTierOrRequirements();
        builder.tier().attributeNode(27, SkillTreeTitles.baseArmor(3), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(18).previousTierOrRequirements().attributeNode(28, SkillTreeTitles.toughness(3), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.5f).nodeRequirement(19).previousTierOrRequirements().enchantmentNode(29, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3)), (ResourceKey<Enchantment>)Enchantments.THORNS, 3).previousTierOrRequirements().attributeNode(30, SkillTreeTitles.moveSpeed(3), desc.moveSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MOVEMENT_SPEED), 1.0f).nodeRequirement(20).previousTierOrRequirements().enchantmentNode(31, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 5), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 5)), (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK, 5).nodeRequirement(29);
        return builder.build();
    }

    private SkillData boots() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Boots");
        SkillData.Builder builder = SkillData.builder(EquipmentSlot.FEET);
        this.armorTier(builder, 0, -1, 1, desc);
        this.armorTier(builder, 4, 0, 2, desc);
        builder.tier().attributeNode(8, SkillTreeTitles.baseArmor(1), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).previousTierOrRequirements().attributeNode(9, SkillTreeTitles.toughness(1), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).previousTierOrRequirements().enchantmentNode(10, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, 4), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, 4)), (ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, 4).previousTierOrRequirements();
        this.armorTier(builder, 11, 4, 3, desc, true);
        builder.tier().attributeNode(15, SkillTreeTitles.baseArmor(2), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(8).previousTierOrRequirements().attributeNode(16, SkillTreeTitles.toughness(2), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.25f).nodeRequirement(9).previousTierOrRequirements().enchantmentNode(17, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, 3)), (ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, 3).previousTierOrRequirements().infiniteDataComponentNode(18, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements();
        this.armorTier(builder, 19, 11, 4, desc, true);
        builder.tier().attributeNode(23, SkillTreeTitles.baseArmor(3), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(15).previousTierOrRequirements().attributeNode(24, SkillTreeTitles.toughness(3), desc.toughness(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS), 0.5f).nodeRequirement(16).previousTierOrRequirements().enchantmentNode(25, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.THORNS, 3)), (ResourceKey<Enchantment>)Enchantments.THORNS, 3).previousTierOrRequirements().enchantmentNode(26, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SOUL_SPEED, 3), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.SOUL_SPEED, 3)), (ResourceKey<Enchantment>)Enchantments.SOUL_SPEED, 3).previousTierOrRequirements().enchantmentNode(27, CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.FROST_WALKER, 0), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.FROST_WALKER, 0)), (ResourceKey<Enchantment>)Enchantments.FROST_WALKER, 2).previousTierOrRequirements().subText("Can be disabled with the mode switch key", "#ABABAB");
        return builder.build();
    }

    private SkillData bow() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Bow");
        SkillData.Builder builder = SkillData.builder(EquipmentSlot.MAINHAND);
        return builder.tier().dataComponentNode(0, SkillTreeTitles.arrowDamage(1), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 1.0f).dataComponentNode(1, SkillTreeTitles.arrowSpeed(1), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 1.0f).dataComponentNode(2, SkillTreeTitles.drawSpeed(1), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 1.0f).dataComponentNode(3, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).tier().dataComponentNode(4, SkillTreeTitles.arrowDamage(2), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 1.0f).nodeRequirement(0).dataComponentNode(5, SkillTreeTitles.arrowSpeed(2), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 1.0f).nodeRequirement(1).dataComponentNode(6, SkillTreeTitles.drawSpeed(2), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 1.0f).nodeRequirement(2).dataComponentNode(7, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(3).tier().enchantmentNode(8, desc, (ResourceKey<Enchantment>)Enchantments.PUNCH, 1).previousTierOrRequirements().enchantmentNode(9, desc, (ResourceKey<Enchantment>)Enchantments.FLAME, 0).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().dataComponentNode(39, SkillTreeTitles.beheading(1), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).previousTierOrRequirements().tier().dataComponentNode(11, SkillTreeTitles.arrowDamage(3), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 1.0f).nodeRequirement(4).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.arrowSpeed(3), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 1.0f).nodeRequirement(5).previousTierOrRequirements().dataComponentNode(13, SkillTreeTitles.drawSpeed(3), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 1.0f).nodeRequirement(6).previousTierOrRequirements().dataComponentNode(14, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(7).previousTierOrRequirements().dataComponentNode(42, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).previousTierOrRequirements().tier().enchantmentNode(15, desc, (ResourceKey<Enchantment>)Enchantments.PUNCH, 2).nodeRequirement(8).previousTierOrRequirements().enchantmentNode(16, desc, (ResourceKey<Enchantment>)Enchantments.INFINITY, 0).previousTierOrRequirements().dataComponentNode(17, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(10).previousTierOrRequirements().dataComponentNode(40, SkillTreeTitles.beheading(2), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(39).previousTierOrRequirements().tier().dataComponentNode(18, SkillTreeTitles.arrowDamage(4), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 1.0f).nodeRequirement(11).previousTierOrRequirements().dataComponentNode(19, SkillTreeTitles.arrowSpeed(4), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 1.0f).nodeRequirement(12).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.drawSpeed(4), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 1.0f).nodeRequirement(13).previousTierOrRequirements().dataComponentNode(21, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(14).previousTierOrRequirements().dataComponentNode(43, SkillTreeTitles.capturing(2), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(42).previousTierOrRequirements().tier().enchantmentNode(22, desc, (ResourceKey<Enchantment>)Enchantments.PUNCH, 3).nodeRequirement(15).previousTierOrRequirements().dataComponentNode(23, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().dataComponentNode(24, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(17).previousTierOrRequirements().dataComponentNode(25, "Auto Target Mobs", desc.autoTarget(false), DataComponents.AUTO_TARGET.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(41, SkillTreeTitles.beheading(3), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(40).previousTierOrRequirements().tier().dataComponentNode(26, SkillTreeTitles.arrowDamage(5), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 1.0f).nodeRequirement(18).previousTierOrRequirements().dataComponentNode(27, SkillTreeTitles.arrowSpeed(5), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 1.0f).nodeRequirement(19).previousTierOrRequirements().dataComponentNode(28, SkillTreeTitles.drawSpeed(5), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 1.0f).nodeRequirement(20).previousTierOrRequirements().dataComponentNode(29, SkillTreeTitles.durability(5), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(21).previousTierOrRequirements().dataComponentNode(44, SkillTreeTitles.capturing(3), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(43).previousTierOrRequirements().tier().infiniteDataComponentNode(30, SkillTreeTitles.arrowDamage(0), desc.arrowDamage(), DataComponents.ARROW_DAMAGE.getId(), 0.2f).nodeRequirement(26).infiniteDataComponentNode(31, SkillTreeTitles.arrowSpeed(0), desc.arrowSpeed(), DataComponents.ARROW_SPEED.getId(), 0.2f).nodeRequirement(27).infiniteDataComponentNode(32, SkillTreeTitles.drawSpeed(0), desc.drawSpeed(), DataComponents.DRAW_SPEED.getId(), 0.2f).nodeRequirement(28).infiniteDataComponentNode(33, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(29).dataComponentNode(34, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).nodeRequirement(24).previousTierOrRequirements().tier().effect(35, desc, new MobEffectInstance(MobEffects.POISON, 120, 1, false, false), "Tipped: ").itemRequirement(Items.NETHER_WART, Items.SPIDER_EYE, Items.FERMENTED_SPIDER_EYE, Items.GLOWSTONE_DUST).previousTierOrRequirements().effect(36, desc, new MobEffectInstance(MobEffects.WEAKNESS, 240, 1, false, false), "Tipped: ").itemRequirement(Items.NETHER_WART, Items.BLAZE_POWDER, Items.FERMENTED_SPIDER_EYE, Items.GLOWSTONE_DUST).previousTierOrRequirements().effect(37, desc, new MobEffectInstance(MobEffects.SLOWNESS, 240, 1, false, false), "Tipped: ").itemRequirement(Items.NETHER_WART, Items.SUGAR, Items.FERMENTED_SPIDER_EYE, Items.GLOWSTONE_DUST).previousTierOrRequirements().effect(38, desc, new MobEffectInstance(MobEffects.WITHER, 120, 1, false, false), "Tipped: ").itemRequirement(Items.NETHER_WART, Items.BONE, Items.FERMENTED_SPIDER_EYE, Items.GLOWSTONE_DUST).previousTierOrRequirements().build();
    }

    private SkillData rocket() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Rocket");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().dataComponentNode(0, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 25.0f).dataComponentNode(1, SkillTreeTitles.flightDuration(1), desc.flightDuration(), DataComponents.FLIGHT_TIME.getId(), 2.0f).itemRequirement(Items.GUNPOWDER).tier().dataComponentNode(2, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 25.0f).nodeRequirement(0).dataComponentNode(3, SkillTreeTitles.flightDuration(2), desc.flightDuration(), DataComponents.FLIGHT_TIME.getId(), 2.0f).nodeRequirement(1).itemRequirement(Items.GUNPOWDER).tier().infiniteDataComponentNode(4, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 10.0f).nodeRequirement(2).infiniteDataComponentNode(5, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f).previousTierOrRequirements().build();
    }

    private SkillData fishingRod() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Fishing Rod");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().enchantmentNode(0, desc, (ResourceKey<Enchantment>)Enchantments.LURE, 1).enchantmentNode(1, desc, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, 1).dataComponentNode(2, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 50.0f).tier().enchantmentNode(3, desc, (ResourceKey<Enchantment>)Enchantments.LURE, 2).nodeRequirement(0).enchantmentNode(4, desc, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, 2).nodeRequirement(1).dataComponentNode(5, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(2).tier().dataComponentNode(6, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().dataComponentNode(7, SkillTreeTitles.doubleItems(1), desc.doubleItems(), DataComponents.DOUBLE_DROPS.getId(), 0.2f).previousTierAndRequirements(new int[0]).tier().enchantmentNode(8, desc, (ResourceKey<Enchantment>)Enchantments.LURE, 3).nodeRequirement(3).previousTierAndRequirements(new int[0]).enchantmentNode(9, desc, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, 3).nodeRequirement(4).previousTierAndRequirements(new int[0]).dataComponentNode(10, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(5).previousTierAndRequirements(new int[0]).tier().dataComponentNode(11, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(6).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.doubleItems(2), desc.doubleItems(), DataComponents.DOUBLE_DROPS.getId(), 0.2f).nodeRequirement(7).previousTierAndRequirements(new int[0]).tier().enchantmentNode(13, desc, (ResourceKey<Enchantment>)Enchantments.LURE, 4).nodeRequirement(8).previousTierAndRequirements(new int[0]).enchantmentNode(14, desc, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, 4).nodeRequirement(9).previousTierAndRequirements(new int[0]).dataComponentNode(15, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(10).previousTierAndRequirements(new int[0]).tier().dataComponentNode(16, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(11).previousTierOrRequirements().dataComponentNode(17, SkillTreeTitles.doubleItems(3), desc.doubleItems(), DataComponents.DOUBLE_DROPS.getId(), 0.2f).nodeRequirement(12).previousTierAndRequirements(new int[0]).dataComponentNode(18, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierAndRequirements(new int[0]).tier().enchantmentNode(19, desc, (ResourceKey<Enchantment>)Enchantments.LURE, 5).nodeRequirement(13).previousTierAndRequirements(new int[0]).enchantmentNode(20, desc, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, 5).nodeRequirement(14).previousTierAndRequirements(new int[0]).dataComponentNode(21, SkillTreeTitles.durability(5), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(15).previousTierAndRequirements(new int[0]).tier().dataComponentNode(22, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).build();
    }

    private SkillData shield() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Shield");
        return SkillData.builder(EquipmentSlot.OFFHAND).tier().dataComponentNode(0, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).attributeNode(1, SkillTreeTitles.baseArmor(1), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).dataComponentNode(2, SkillTreeTitles.thorns(1), desc.thorns(), DataComponents.SHIELD_THORNS.getId(), 1.0f).dataComponentNode(3, SkillTreeTitles.shieldCooldown(1), desc.shieldCooldown(), SkillConstants.BLOCKS_ATTACKS, 0.1f).tier().attributeNode(4, SkillTreeTitles.attackDamage(1), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 2.0f).previousTierOrRequirements().dataComponentNode(5, SkillTreeTitles.flamingShield(1), desc.flamingShield(), DataComponents.FLAMING_SHIELD.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(6, SkillTreeTitles.totemSlot(1), desc.totemSlot(), DataComponents.TOTEM_SLOTS.getId(), 1.0f).subText("Craft with a Totem of Undying to add one", "#ABABAB").previousTierOrRequirements().effect(7, desc, new MobEffectInstance(MobEffects.SLOWNESS, 100, 1), "", false).previousTierOrRequirements().tier().dataComponentNode(8, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(0).previousTierOrRequirements().attributeNode(9, SkillTreeTitles.baseArmor(2), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(1).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.thorns(2), desc.thorns(), DataComponents.SHIELD_THORNS.getId(), 1.0f).nodeRequirement(2).previousTierOrRequirements().dataComponentNode(11, SkillTreeTitles.shieldCooldown(2), desc.shieldCooldown(), SkillConstants.BLOCKS_ATTACKS, 0.1f).nodeRequirement(3).previousTierOrRequirements().dataComponentNode(12, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().tier().attributeNode(13, SkillTreeTitles.attackDamage(2), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 2.0f).nodeRequirement(4).previousTierOrRequirements().dataComponentNode(14, "Shield Knockback", desc.shieldKnockback(), DataComponents.SHIELD_KNOCKBACK.getId(), 1.0f).itemRequirement(Items.WIND_CHARGE).previousTierOrRequirements().dataComponentNode(15, SkillTreeTitles.totemSlot(1), desc.totemSlot(), DataComponents.TOTEM_SLOTS.getId(), 1.0f).subText("Craft with a Totem of Undying to add one", "#ABABAB").nodeRequirement(6).previousTierOrRequirements().effect(16, desc, new MobEffectInstance(MobEffects.POISON, 100, 1), "", false).previousTierOrRequirements().tier().dataComponentNode(17, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(8).previousTierOrRequirements().attributeNode(18, SkillTreeTitles.baseArmor(3), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(9).previousTierOrRequirements().dataComponentNode(19, SkillTreeTitles.thorns(3), desc.thorns(), DataComponents.SHIELD_THORNS.getId(), 1.0f).nodeRequirement(10).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.shieldCooldown(3), desc.shieldCooldown(), SkillConstants.BLOCKS_ATTACKS, 0.1f).nodeRequirement(11).previousTierOrRequirements().tier().attributeNode(21, SkillTreeTitles.attackDamage(3), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 2.0f).nodeRequirement(13).previousTierOrRequirements().dataComponentNode(22, "Auto Target Mobs", desc.autoTarget(true), DataComponents.AUTO_TARGET.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(23, SkillTreeTitles.totemSlot(1), desc.totemSlot(), DataComponents.TOTEM_SLOTS.getId(), 1.0f).subText("Craft with a Totem of Undying to add one", "#ABABAB").nodeRequirement(15).previousTierOrRequirements().effect(24, desc, new MobEffectInstance(MobEffects.WITHER, 100, 1), "", false).previousTierOrRequirements().tier().dataComponentNode(25, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(17).previousTierOrRequirements().attributeNode(26, SkillTreeTitles.baseArmor(4), desc.baseArmor(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ARMOR), 1.0f).nodeRequirement(18).previousTierOrRequirements().dataComponentNode(27, SkillTreeTitles.thorns(4), desc.thorns(), DataComponents.SHIELD_THORNS.getId(), 1.0f).nodeRequirement(19).previousTierOrRequirements().dataComponentNode(28, SkillTreeTitles.shieldCooldown(4), desc.shieldCooldown(), SkillConstants.BLOCKS_ATTACKS, 0.1f).nodeRequirement(20).previousTierOrRequirements().tier().infiniteDataComponentNode(29, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(25).infiniteAttributeNode(30, SkillTreeTitles.attackDamage(0), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 0.1f).nodeRequirement(21).previousTierOrRequirements().dataComponentNode(31, SkillTreeTitles.shieldCooldown(0), desc.shieldCooldown(), SkillConstants.BLOCKS_ATTACKS, 0.25f, 24).subText("When you have all points here, the shield can't be disabled!", "#ABABAB").nodeRequirement(28).build();
    }

    private SkillData trident() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Trident");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().attributeNode(0, SkillTreeTitles.attackDamage(1), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).dataComponentNode(1, SkillTreeTitles.projectileDamage(1), desc.projectileDamage(), DataComponents.PROJECTILE_DAMAGE.getId(), 1.0f).dataComponentNode(2, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).tier().dataComponentNode(3, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().dataComponentNode(4, SkillTreeTitles.projectileSpeed(1), desc.projectileSpeed(), DataComponents.PROJECTILE_SPEED.getId(), 1.0f).previousTierOrRequirements().attributeNode(5, SkillTreeTitles.reach(1), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).previousTierOrRequirements().dataComponentNode(6, SkillTreeTitles.beheading(1), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).previousTierOrRequirements().tier().dataComponentNode(7, SkillTreeTitles.riptide(1), desc.riptide(), DataComponents.RIPTIDE.getId(), 1.0f).previousTierOrRequirements().notNodeRequirement(8, 32).enchantmentNode(8, desc, (ResourceKey<Enchantment>)Enchantments.LOYALTY, 1).previousTierOrRequirements().notNodeRequirement(7, 32).dataComponentNode(9, "Channeling", desc.channeling(), DataComponents.CHANNELING.getId(), 1.0f, 0).previousTierOrRequirements().notNodeRequirement(7, 32).dataComponentNode(10, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).previousTierOrRequirements().tier().attributeNode(11, SkillTreeTitles.attackDamage(2), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(0).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.projectileDamage(2), desc.projectileDamage(), DataComponents.PROJECTILE_DAMAGE.getId(), 1.0f).nodeRequirement(1).previousTierOrRequirements().dataComponentNode(13, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(2).previousTierOrRequirements().tier().dataComponentNode(14, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(3).previousTierOrRequirements().dataComponentNode(15, SkillTreeTitles.projectileSpeed(2), desc.projectileSpeed(), DataComponents.PROJECTILE_SPEED.getId(), 1.0f).nodeRequirement(4).previousTierOrRequirements().attributeNode(16, SkillTreeTitles.reach(2), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(5).previousTierOrRequirements().dataComponentNode(17, SkillTreeTitles.beheading(2), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(6).previousTierOrRequirements().tier().dataComponentNode(18, SkillTreeTitles.riptide(2), desc.riptide(), DataComponents.RIPTIDE.getId(), 1.0f).nodeRequirement(7).previousTierOrRequirements().notNodeRequirement(8, 32).enchantmentNode(19, desc, (ResourceKey<Enchantment>)Enchantments.LOYALTY, 2).nodeRequirement(8).previousTierOrRequirements().notNodeRequirement(7, 32).dataComponentNode(20, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(10).previousTierOrRequirements().dataComponentNode(21, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().tier().attributeNode(22, SkillTreeTitles.attackDamage(3), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(11).previousTierOrRequirements().dataComponentNode(23, SkillTreeTitles.projectileDamage(3), desc.projectileDamage(), DataComponents.PROJECTILE_DAMAGE.getId(), 1.0f).nodeRequirement(12).previousTierOrRequirements().dataComponentNode(24, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(13).previousTierOrRequirements().tier().dataComponentNode(25, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(14).previousTierOrRequirements().dataComponentNode(26, SkillTreeTitles.projectileSpeed(3), desc.projectileSpeed(), DataComponents.PROJECTILE_SPEED.getId(), 1.0f).nodeRequirement(15).previousTierOrRequirements().attributeNode(27, SkillTreeTitles.reach(3), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(16).previousTierOrRequirements().dataComponentNode(28, SkillTreeTitles.beheading(3), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(17).previousTierOrRequirements().tier().dataComponentNode(29, SkillTreeTitles.riptide(3), desc.riptide(), DataComponents.RIPTIDE.getId(), 1.0f).nodeRequirement(18).previousTierOrRequirements().notNodeRequirement(8, 32).enchantmentNode(30, desc, (ResourceKey<Enchantment>)Enchantments.LOYALTY, 3).nodeRequirement(19).previousTierOrRequirements().notNodeRequirement(7, 32).dataComponentNode(31, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(20).previousTierOrRequirements().dataComponentNode(32, "Riptide Toggle", desc.riptideToggle(), DataComponents.MINE_MODE.getId(), 1.0f).previousTierOrRequirements().tier().infiniteAttributeNode(33, SkillTreeTitles.attackDamage(0), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 0.25f).nodeRequirement(22).previousTierOrRequirements().infiniteDataComponentNode(34, SkillTreeTitles.projectileDamage(0), desc.projectileDamage(), DataComponents.PROJECTILE_DAMAGE.getId(), 0.25f).nodeRequirement(23).previousTierOrRequirements().infiniteDataComponentNode(35, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(24).previousTierOrRequirements().dataComponentNode(36, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).nodeRequirement(25).previousTierOrRequirements().infiniteDataComponentNode(37, SkillTreeTitles.projectileSpeed(0), desc.projectileSpeed(), DataComponents.PROJECTILE_SPEED.getId(), 0.25f).nodeRequirement(26).previousTierOrRequirements().infiniteAttributeNode(38, SkillTreeTitles.reach(0), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 0.1f).nodeRequirement(27).previousTierOrRequirements().infiniteDataComponentNode(39, SkillTreeTitles.riptide(0), desc.riptide(), DataComponents.RIPTIDE.getId(), 0.25f).nodeRequirement(new int[0]).previousTierOrRequirements().tier().dataComponentNode(40, "Always Riptide", "Allows you to Riptide even when it isn't raining", DataComponents.ALWAYS_RIPTIDE.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(41, "Instant Loyalty", "The Trident instantly comes back to you", DataComponents.INSTANT_LOYALTY.getId(), 1.0f).previousTierAndRequirements(new int[0]).build();
    }

    private SkillData aiot() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("AIOT");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().attributeNode(0, SkillTreeTitles.miningSpeed(1), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).attributeNode(1, SkillTreeTitles.attackDamage(1), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).attributeNode(2, SkillTreeTitles.attackSpeed(1), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).dataComponentNode(3, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).tier().attributeNode(4, SkillTreeTitles.miningSpeed(2), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(0).attributeNode(5, SkillTreeTitles.attackDamage(2), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(1).attributeNode(6, SkillTreeTitles.attackSpeed(2), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(2).dataComponentNode(7, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(3).tier().enchantmentNode(8, desc, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, 1).notNodeRequirement(9, 40).previousTierOrRequirements().enchantmentNode(9, desc, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 3).notNodeRequirement(8, 40).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().attributeNode(11, SkillTreeTitles.reach(1), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.beheading(1), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).previousTierOrRequirements().tier().enchantmentNode(13, desc, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, 2).previousTierOrRequirements().attributeNode(14, SkillTreeTitles.knockback(1), desc.knockback(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK), 1.0f).previousTierOrRequirements().attributeNode(15, SkillTreeTitles.knockbackResistance(1), desc.knockbackResistance(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 1.0f).previousTierOrRequirements().dataComponentNode(16, SkillTreeTitles.capturing(1), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).previousTierOrRequirements().tier().attributeNode(17, SkillTreeTitles.miningSpeed(3), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(4).previousTierOrRequirements().attributeNode(18, SkillTreeTitles.attackDamage(3), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(5).previousTierOrRequirements().attributeNode(19, SkillTreeTitles.attackSpeed(3), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(6).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(7).previousTierOrRequirements().enchantmentNode(21, desc, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, 3).previousTierOrRequirements().tier().dataComponentNode(22, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().dataComponentNode(23, "3x3 Mining", desc.mining3x3(), DataComponents.HAS_3x3.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(24, "Vein Mining", desc.veinMining(false), DataComponents.VEIN_MINER.getId(), 1.0f, 0).subText("+1 block range per level", "#ABABAB").previousTierOrRequirements().dataComponentNode(25, "Auto Smelting", desc.autoSmelting(), DataComponents.AUTO_SMELT.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(26, SkillTreeTitles.capturing(2), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(16).previousTierOrRequirements().dataComponentNode(57, "Shears", desc.shears(), DataComponents.SHEAR.getId(), 1.0f).itemRequirement(Items.SHEARS).previousTierOrRequirements().tier().dataComponentNode(27, SkillTreeTitles.lifesteal(1), desc.lifesteal(), DataComponents.LIFESTEAL.getId(), 2.0f).previousTierOrRequirements().attributeNode(28, SkillTreeTitles.knockback(2), desc.knockback(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK), 1.0f).nodeRequirement(14).previousTierOrRequirements().attributeNode(29, SkillTreeTitles.knockbackResistance(2), desc.knockbackResistance(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 1.0f).nodeRequirement(15).previousTierOrRequirements().dataComponentNode(30, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(10).previousTierOrRequirements().attributeNode(31, SkillTreeTitles.reach(2), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(11).previousTierOrRequirements().dataComponentNode(32, SkillTreeTitles.beheading(2), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(12).previousTierOrRequirements().tier().attributeNode(33, SkillTreeTitles.miningSpeed(4), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(17).previousTierOrRequirements().attributeNode(34, SkillTreeTitles.attackDamage(4), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(18).previousTierOrRequirements().attributeNode(35, SkillTreeTitles.attackSpeed(4), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(19).previousTierOrRequirements().dataComponentNode(36, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(20).previousTierOrRequirements().dataComponentNode(37, "Auto Pickup", desc.autoPickup(), DataComponents.AUTO_PICKUP.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(38, SkillTreeTitles.capturing(3), desc.capturing(), DataComponents.CAPTURING.getId(), 0.01f).nodeRequirement(26).previousTierOrRequirements().tier().dataComponentNode(39, "Torch", desc.torch(), DataComponents.TORCH.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(40, "Mode Switch", desc.mineMode(), DataComponents.MINE_MODE.getId(), 1.0f).previousTierOrRequirements().enchantmentNode(41, desc, (ResourceKey<Enchantment>)Enchantments.LOOTING, 3).previousTierOrRequirements().dataComponentNode(42, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(30).previousTierOrRequirements().attributeNode(43, SkillTreeTitles.reach(3), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 1.0f).nodeRequirement(31).previousTierOrRequirements().dataComponentNode(44, SkillTreeTitles.beheading(3), desc.beheading(), DataComponents.BEHEADING.getId(), 0.1f).nodeRequirement(32).previousTierOrRequirements().tier().attributeNode(45, SkillTreeTitles.miningSpeed(5), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 6.0f).nodeRequirement(33).previousTierOrRequirements().attributeNode(46, SkillTreeTitles.attackDamage(5), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 1.0f).nodeRequirement(34).previousTierOrRequirements().attributeNode(47, SkillTreeTitles.attackSpeed(5), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 1.0f).nodeRequirement(35).previousTierOrRequirements().dataComponentNode(48, SkillTreeTitles.durability(5), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(36).previousTierOrRequirements().tier().infiniteAttributeNode(49, SkillTreeTitles.miningSpeed(0), desc.miningSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.MINING_EFFICIENCY), 0.05f).nodeRequirement(45).infiniteAttributeNode(50, SkillTreeTitles.attackDamage(0), desc.attackDamage(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_DAMAGE), 0.25f).nodeRequirement(46).infiniteAttributeNode(51, SkillTreeTitles.attackSpeed(0), desc.attackSpeed(), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ATTACK_SPEED), 0.25f).nodeRequirement(47).infiniteDataComponentNode(52, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(48).dataComponentNode(53, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).nodeRequirement(42).previousTierOrRequirements().infiniteAttributeNode(54, SkillTreeTitles.reach(0), desc.reach(), List.of(CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE), CrystalToolsItemSkillTrees.attr((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE)), 0.1f).nodeRequirement(43).previousTierOrRequirements().tier().enchantmentNode(55, desc, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 5).previousTierAndRequirements(9).enchantmentNode(56, desc, (ResourceKey<Enchantment>)Enchantments.LOOTING, 5).previousTierAndRequirements(41).build();
    }

    private SkillData backpack() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Backpack");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().dataComponentNode(0, SkillTreeTitles.capacity(1), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).dataComponentNode(1, SkillTreeTitles.filterSlots(1), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).dataComponentNode(2, "Auto Pickup", desc.backpackPickup(), DataComponents.BACKPACK_AUTO_PICKUP.getId(), 1.0f).tier().dataComponentNode(3, SkillTreeTitles.capacity(2), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).nodeRequirement(0).dataComponentNode(4, SkillTreeTitles.filterSlots(2), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(1).tier().dataComponentNode(5, SkillTreeTitles.capacity(3), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).nodeRequirement(3).dataComponentNode(6, SkillTreeTitles.filterSlots(3), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(4).dataComponentNode(7, "Sort", desc.sort(), DataComponents.SORT_ENABLED.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(8, SkillTreeTitles.capacity(4), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).nodeRequirement(5).dataComponentNode(9, SkillTreeTitles.filterSlots(4), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(6).tier().dataComponentNode(10, SkillTreeTitles.capacity(5), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).nodeRequirement(8).dataComponentNode(11, SkillTreeTitles.filterSlots(5), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(9).dataComponentNode(12, "Store in Inventory", desc.store(), DataComponents.INVENTORY_STORE.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(13, SkillTreeTitles.capacity(6), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).nodeRequirement(10).dataComponentNode(14, SkillTreeTitles.filterSlots(6), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(11).dataComponentNode(15, "Compress", desc.compress(), DataComponents.COMPRESSION_ENABLED.getId(), 1.0f).previousTierOrRequirements().tier().infiniteDataComponentNode(16, SkillTreeTitles.capacity(0), desc.capacity(), DataComponents.CAPACITY.getId(), 1.0f).previousTierAndRequirements(new int[0]).build();
    }

    private SkillData magnet() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Magnet");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().dataComponentNode(0, SkillTreeTitles.durability(1), desc.durability(), SkillConstants.DURABILITY, 200.0f).dataComponentNode(1, SkillTreeTitles.itemSpeed(1), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).dataComponentNode(2, SkillTreeTitles.magnetRange(1), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).tier().dataComponentNode(3, SkillTreeTitles.durability(2), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(0).dataComponentNode(4, SkillTreeTitles.itemSpeed(2), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).nodeRequirement(1).dataComponentNode(5, SkillTreeTitles.magnetRange(2), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).nodeRequirement(2).tier().dataComponentNode(6, SkillTreeTitles.filterSlots(1), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).previousTierOrRequirements().dataComponentNode(7, SkillTreeTitles.unbreaking(1), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).previousTierOrRequirements().dataComponentNode(8, "Attract EXP", desc.pullXp(), DataComponents.PULL_XP.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(9, SkillTreeTitles.durability(3), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(3).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.itemSpeed(3), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).nodeRequirement(4).previousTierOrRequirements().dataComponentNode(11, SkillTreeTitles.magnetRange(3), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).nodeRequirement(5).previousTierOrRequirements().tier().dataComponentNode(12, SkillTreeTitles.durability(4), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(9).dataComponentNode(13, SkillTreeTitles.itemSpeed(4), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).nodeRequirement(10).dataComponentNode(14, SkillTreeTitles.magnetRange(4), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).nodeRequirement(11).tier().dataComponentNode(15, SkillTreeTitles.filterSlots(2), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(6).previousTierOrRequirements().dataComponentNode(16, SkillTreeTitles.unbreaking(2), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(7).previousTierOrRequirements().dataComponentNode(17, "Attract Mobs", desc.pullMobs(), DataComponents.PULL_MOBS.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(18, SkillTreeTitles.durability(5), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(12).previousTierOrRequirements().dataComponentNode(19, SkillTreeTitles.itemSpeed(5), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).nodeRequirement(13).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.magnetRange(5), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).nodeRequirement(14).previousTierOrRequirements().tier().dataComponentNode(21, SkillTreeTitles.durability(6), desc.durability(), SkillConstants.DURABILITY, 200.0f).nodeRequirement(18).dataComponentNode(22, SkillTreeTitles.itemSpeed(6), desc.itemSpeed(), DataComponents.ITEM_SPEED.getId(), 0.05f).nodeRequirement(19).dataComponentNode(23, SkillTreeTitles.magnetRange(6), desc.magnetRange(), DataComponents.MAGNET_RANGE.getId(), 1.0f).nodeRequirement(20).tier().dataComponentNode(24, SkillTreeTitles.filterSlots(3), desc.filterSlots(), DataComponents.FILTER_CAPACITY.getId(), 1.0f).nodeRequirement(15).previousTierOrRequirements().dataComponentNode(25, SkillTreeTitles.unbreaking(3), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.1f).nodeRequirement(16).previousTierOrRequirements().dataComponentNode(26, "Instant Pickup", desc.instantPickup(), DataComponents.INSTANT_PICKUP.getId(), 1.0f).previousTierAndRequirements(new int[0]).dataComponentNode(27, "Auto Repair", desc.autoRepair(), DataComponents.AUTO_REPAIR.getId(), 1.0f, 0).previousTierOrRequirements().tier().dataComponentNode(28, SkillTreeTitles.unbreaking(0), desc.unbreaking(), DataComponents.UNBREAKING.getId(), 0.01f, 70).nodeRequirement(25).previousTierOrRequirements().infiniteDataComponentNode(29, SkillTreeTitles.durability(0), desc.durability(), SkillConstants.DURABILITY, 50.0f).nodeRequirement(21).previousTierOrRequirements().build();
    }

    private SkillData portableGenerator() {
        SkillTreeDescriptions desc = new SkillTreeDescriptions("Portable Generator");
        return SkillData.builder(EquipmentSlot.MAINHAND).tier().dataComponentNode(0, SkillTreeTitles.feGeneration(1), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).dataComponentNode(1, SkillTreeTitles.fuelEfficiency(1), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).dataComponentNode(2, SkillTreeTitles.feCapacity(1), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).dataComponentNode(3, SkillTreeTitles.portableGeneratorSlots(1), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).tier().dataComponentNode(4, SkillTreeTitles.feGeneration(2), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(0).dataComponentNode(5, SkillTreeTitles.fuelEfficiency(2), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(1).dataComponentNode(6, SkillTreeTitles.feCapacity(2), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(2).dataComponentNode(7, SkillTreeTitles.portableGeneratorSlots(2), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).nodeRequirement(3).tier().dataComponentNode(8, "Metal Generator", desc.metalGenerator(), DataComponents.METAL_GENERATOR.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(9, SkillTreeTitles.feGeneration(3), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(4).previousTierOrRequirements().dataComponentNode(10, SkillTreeTitles.fuelEfficiency(3), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(5).previousTierOrRequirements().dataComponentNode(11, SkillTreeTitles.feCapacity(3), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(6).previousTierOrRequirements().dataComponentNode(12, SkillTreeTitles.portableGeneratorSlots(3), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).nodeRequirement(7).previousTierOrRequirements().tier().dataComponentNode(13, SkillTreeTitles.feGeneration(4), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(9).dataComponentNode(14, SkillTreeTitles.fuelEfficiency(4), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(10).dataComponentNode(15, SkillTreeTitles.feCapacity(4), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(11).dataComponentNode(16, SkillTreeTitles.portableGeneratorSlots(4), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).nodeRequirement(12).tier().dataComponentNode(17, "Food Generator", desc.metalGenerator(), DataComponents.FOOD_GENERATOR.getId(), 1.0f).previousTierOrRequirements().tier().dataComponentNode(18, SkillTreeTitles.feGeneration(5), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(13).previousTierOrRequirements().dataComponentNode(19, SkillTreeTitles.fuelEfficiency(5), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(14).previousTierOrRequirements().dataComponentNode(20, SkillTreeTitles.feCapacity(5), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(15).previousTierOrRequirements().dataComponentNode(21, SkillTreeTitles.portableGeneratorSlots(5), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).nodeRequirement(16).previousTierOrRequirements().tier().dataComponentNode(22, SkillTreeTitles.feGeneration(6), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(18).dataComponentNode(23, SkillTreeTitles.fuelEfficiency(6), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(19).dataComponentNode(24, SkillTreeTitles.feCapacity(6), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(20).dataComponentNode(25, SkillTreeTitles.portableGeneratorSlots(6), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f).nodeRequirement(21).tier().dataComponentNode(26, "Gem Generator", desc.gemGenerator(), DataComponents.GEM_GENERATOR.getId(), 1.0f).previousTierOrRequirements().tier().infiniteDataComponentNode(27, SkillTreeTitles.feGeneration(0), desc.feGeneration(), DataComponents.FE_GENERATION.getId(), 1.0f).nodeRequirement(22).previousTierOrRequirements().infiniteDataComponentNode(28, SkillTreeTitles.fuelEfficiency(0), desc.fuelEfficiency(), DataComponents.FUEL_EFFICIENCY.getId(), 0.1f).nodeRequirement(23).previousTierOrRequirements().infiniteDataComponentNode(29, SkillTreeTitles.feCapacity(0), desc.feCapacity(), DataComponents.FE_CAPACITY.getId(), 1.0f).nodeRequirement(24).previousTierOrRequirements().dataComponentNode(30, SkillTreeTitles.portableGeneratorSlots(0), desc.portableGeneratorSlots(), DataComponents.PORTABLE_GENERATOR_SLOTS.getId(), 1.0f, 20).nodeRequirement(25).previousTierOrRequirements().build();
    }

    private void armorTier(SkillData.Builder builder, int indexStart, int prevIndexStart, int level, SkillTreeDescriptions desc) {
        this.armorTier(builder, indexStart, prevIndexStart, level, desc, false);
    }

    private void armorTier(SkillData.Builder builder, int indexStart, int prevIndexStart, int level, SkillTreeDescriptions desc, boolean previousTierOrRequirements) {
        builder.tier().enchantmentNode(indexStart++, SkillTreeTitles.protection(level), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.PROTECTION, level)), (ResourceKey<Enchantment>)Enchantments.PROTECTION, level).optional(prevIndexStart >= 0).nodeRequirement(prevIndexStart++).endOptional().optional(previousTierOrRequirements).previousTierOrRequirements().endOptional().enchantmentNode(indexStart++, SkillTreeTitles.fireProtection(level), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, level)), (ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, level).optional(prevIndexStart >= 0).nodeRequirement(prevIndexStart++).endOptional().optional(previousTierOrRequirements).previousTierOrRequirements().endOptional().enchantmentNode(indexStart++, SkillTreeTitles.blastProtection(level), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, level)), (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, level).optional(prevIndexStart >= 0).nodeRequirement(prevIndexStart++).endOptional().optional(previousTierOrRequirements).previousTierOrRequirements().endOptional().enchantmentNode(indexStart, SkillTreeTitles.projectileProtection(level), desc.enchantment(CrystalToolsItemSkillTrees.enchantmentName((ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, level)), (ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, level).optional(prevIndexStart >= 0).nodeRequirement(prevIndexStart).endOptional().optional(previousTierOrRequirements).previousTierOrRequirements().endOptional();
    }

    public static ResourceLocation attr(Holder<Attribute> attribute) {
        ResourceKey key = attribute.getKey();
        if (key == null) {
            throw new IllegalArgumentException("Invalid attribute " + String.valueOf(attribute));
        }
        return key.location();
    }

    public static String enchantmentName(ResourceKey<Enchantment> enchantment, int level) {
        if (level == 0) {
            return StringUtils.formatKey(enchantment.location().getPath());
        }
        return StringUtils.formatKey(enchantment.location().getPath()) + " " + SkillTreeTitles.intToRomanNumeral(level);
    }
}

