/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.client.model.property.Disabled;
import dev.willyelton.crystal_tools.client.model.property.Lit;
import dev.willyelton.crystal_tools.client.renderer.CrystalShieldRenderer;
import dev.willyelton.crystal_tools.client.renderer.CrystalTridentSpecialRenderer;
import dev.willyelton.crystal_tools.client.renderer.item.properties.BowUseDuration;
import dev.willyelton.crystal_tools.common.levelable.armor.CrystalToolsArmorMaterials;
import dev.willyelton.crystal_tools.datagen.CrystalToolsModelTemplates;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ConditionalItemModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CrystalToolsModels
extends ModelProvider {
    public CrystalToolsModels(PackOutput output) {
        super(output, "crystal_tools");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.NETHERITE_STICK.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.NETHERITE_INFUSED_CRYSTAL_SHARD.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_APPLE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_BACKPACK.get(), ModelTemplates.FLAT_ITEM);
        this.generateCrystalMagnet(itemModels);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_AIOT.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_AXE.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_HOE.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_PICKAXE.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_ROCKET.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_SHOVEL.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_SWORD.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        this.generateCrystalBow(itemModels);
        this.generateCrystalTrident(itemModels);
        itemModels.generateFishingRod((Item)ModRegistration.CRYSTAL_FISHING_ROD.get());
        this.generateCrystalShield(itemModels);
        this.generatePortableGenerator(itemModels);
        itemModels.generateTrimmableItem((Item)ModRegistration.CRYSTAL_HELMET.get(), CrystalToolsArmorMaterials.CRYSTAL_EQUIPMENT_ASSET, ItemModelGenerators.TRIM_PREFIX_HELMET, false);
        itemModels.generateTrimmableItem((Item)ModRegistration.CRYSTAL_CHESTPLATE.get(), CrystalToolsArmorMaterials.CRYSTAL_EQUIPMENT_ASSET, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, false);
        itemModels.generateTrimmableItem((Item)ModRegistration.CRYSTAL_LEGGINGS.get(), CrystalToolsArmorMaterials.CRYSTAL_EQUIPMENT_ASSET, ItemModelGenerators.TRIM_PREFIX_LEGGINGS, false);
        itemModels.generateTrimmableItem((Item)ModRegistration.CRYSTAL_BOOTS.get(), CrystalToolsArmorMaterials.CRYSTAL_EQUIPMENT_ASSET, ItemModelGenerators.TRIM_PREFIX_BOOTS, false);
        itemModels.generateFlatItem((Item)ModRegistration.CRYSTAL_ELYTRA.get(), ModelTemplates.FLAT_ITEM);
        blockModels.createTrivialCube((Block)ModRegistration.CRYSTAL_BLOCK.get());
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_BLOCK_ITEM.get());
        blockModels.createTrivialCube((Block)ModRegistration.CRYSTAL_GEODE.get());
        blockModels.createTrivialCube((Block)ModRegistration.NETHERITE_INFUSED_CRYSTAL_GEODE.get());
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_GEODE_BLOCK_ITEM.get());
        blockModels.createFlatItemModel((Item)ModRegistration.NETHERITE_INFUSED_CRYSTAL_GEODE_BLOCK_ITEM.get());
        blockModels.createTrivialCube((Block)ModRegistration.CRYSTAL_ORE.get());
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_ORE_ITEM.get());
        blockModels.createTrivialCube((Block)ModRegistration.CRYSTAL_DEEPSLATE_ORE.get());
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_DEEPSLATE_ORE_ITEM.get());
        blockModels.createNormalTorch((Block)ModRegistration.CRYSTAL_TORCH.get(), (Block)ModRegistration.CRYSTAL_WALL_TORCH.get());
        blockModels.createFurnace((Block)ModRegistration.CRYSTAL_FURNACE.get(), TexturedModel.ORIENTABLE_ONLY_TOP);
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_FURNACE_ITEM.get());
        blockModels.createFurnace((Block)ModRegistration.CRYSTAL_GENERATOR.get(), TexturedModel.ORIENTABLE_ONLY_TOP);
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_GENERATOR_ITEM.get());
        blockModels.createFurnace((Block)ModRegistration.CRYSTAL_QUARRY.get(), TexturedModel.ORIENTABLE_ONLY_TOP);
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_QUARRY_ITEM.get());
        blockModels.createFlatItemModel((Item)ModRegistration.QUARRY_STABILIZER_ITEM.get());
        blockModels.createFlatItemModel((Item)ModRegistration.CRYSTAL_PEDESTAL_ITEM.get());
    }

    private void generateCrystalBow(ItemModelGenerators itemModels) {
        Item bowItem = (Item)ModRegistration.CRYSTAL_BOW.get();
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, CrystalToolsModelTemplates.CRYSTAL_BOW));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_0", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_1", ModelTemplates.BOW));
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(bowItem, "_pulling_2", ModelTemplates.BOW));
        itemModels.itemModelOutput.accept(bowItem, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new BowUseDuration(), (float)1.0f, (ItemModel.Unbaked)itemmodel$unbaked1, (RangeSelectItemModel.Entry[])new RangeSelectItemModel.Entry[]{ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked2, (float)0.65f), ItemModelUtils.override((ItemModel.Unbaked)itemmodel$unbaked3, (float)0.9f)}), (ItemModel.Unbaked)itemmodel$unbaked));
    }

    private void generateCrystalTrident(ItemModelGenerators itemModels) {
        Item tridentItem = (Item)ModRegistration.CRYSTAL_TRIDENT.get();
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(tridentItem, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.specialModel((ResourceLocation)CrystalToolsModelTemplates.CRYSTAL_TRIDENT_IN_HAND.create(tridentItem, TextureMapping.particle((ResourceLocation)CrystalTools.rl("block/crystal_block")), itemModels.modelOutput), (SpecialModelRenderer.Unbaked)new CrystalTridentSpecialRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked2 = ItemModelUtils.specialModel((ResourceLocation)CrystalToolsModelTemplates.CRYSTAL_TRIDENT_THROWING.create(tridentItem, TextureMapping.particle((ResourceLocation)CrystalTools.rl("block/crystal_block")), itemModels.modelOutput), (SpecialModelRenderer.Unbaked)new CrystalTridentSpecialRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked3 = ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)itemmodel$unbaked2, (ItemModel.Unbaked)itemmodel$unbaked1);
        itemModels.itemModelOutput.accept(tridentItem, ItemModelGenerators.createFlatModelDispatch((ItemModel.Unbaked)itemmodel$unbaked, (ItemModel.Unbaked)itemmodel$unbaked3));
    }

    private void generateCrystalShield(ItemModelGenerators itemModels) {
        Item shieldItem = (Item)ModRegistration.CRYSTAL_SHIELD.get();
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.specialModel((ResourceLocation)CrystalToolsModelTemplates.CRYSTAL_SHIELD.create(shieldItem, TextureMapping.particle((Block)((Block)ModRegistration.CRYSTAL_BLOCK.get())), itemModels.modelOutput), (SpecialModelRenderer.Unbaked)new CrystalShieldRenderer.Unbaked());
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.specialModel((ResourceLocation)CrystalToolsModelTemplates.CRYSTAL_SHIELD_BLOCKING.create(shieldItem, TextureMapping.particle((Block)((Block)ModRegistration.CRYSTAL_BLOCK.get())), itemModels.modelOutput), (SpecialModelRenderer.Unbaked)new CrystalShieldRenderer.Unbaked());
        itemModels.generateBooleanDispatch((Item)ModRegistration.CRYSTAL_SHIELD.get(), ItemModelUtils.isUsingItem(), itemmodel$unbaked1, itemmodel$unbaked);
    }

    private void generateCrystalMagnet(ItemModelGenerators itemModels) {
        Item magnetItem = (Item)ModRegistration.CRYSTAL_MAGNET.get();
        ItemModel.Unbaked enabled = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(magnetItem, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked disabled = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(magnetItem, "_disabled", ModelTemplates.FLAT_ITEM));
        itemModels.itemModelOutput.accept(magnetItem, (ItemModel.Unbaked)new ConditionalItemModel.Unbaked((ConditionalItemModelProperty)new Disabled(), disabled, enabled));
    }

    private void generatePortableGenerator(ItemModelGenerators itemModels) {
        Item portableGenerator = (Item)ModRegistration.PORTABLE_GENERATOR.get();
        ItemModel.Unbaked unLit = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(portableGenerator, ModelTemplates.FLAT_HANDHELD_ITEM));
        ItemModel.Unbaked lit = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(portableGenerator, "_lit", ModelTemplates.FLAT_HANDHELD_ITEM));
        itemModels.itemModelOutput.accept(portableGenerator, (ItemModel.Unbaked)new ConditionalItemModel.Unbaked((ConditionalItemModelProperty)new Lit(), lit, unLit));
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return super.getKnownBlocks().filter(h -> !((Block)h.value()).equals(ModRegistration.QUARRY_STABILIZER.get()) && !((Block)h.value()).equals(ModRegistration.CRYSTAL_PEDESTAL.get()));
    }
}

