/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BlockCollectors {
    public static List<BlockPos> collect3x3(BlockPos pos, Direction direction) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        result.add(pos);
        switch (direction) {
            case UP: 
            case DOWN: {
                result.add(pos.north());
                result.add(pos.south());
                result.add(pos.east());
                result.add(pos.west());
                result.add(pos.north().east());
                result.add(pos.north().west());
                result.add(pos.south().east());
                result.add(pos.south().west());
                break;
            }
            case NORTH: 
            case SOUTH: {
                result.add(pos.above());
                result.add(pos.below());
                result.add(pos.east());
                result.add(pos.west());
                result.add(pos.east().above());
                result.add(pos.west().above());
                result.add(pos.east().below());
                result.add(pos.west().below());
                break;
            }
            case EAST: 
            case WEST: {
                result.add(pos.above());
                result.add(pos.below());
                result.add(pos.north());
                result.add(pos.south());
                result.add(pos.north().above());
                result.add(pos.south().above());
                result.add(pos.north().below());
                result.add(pos.south().below());
            }
        }
        return result;
    }

    public static List<BlockPos> collect3x3Hoe(BlockPos pos) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        result.add(pos);
        result.add(pos.north());
        result.add(pos.south());
        result.add(pos.east());
        result.add(pos.west());
        result.add(pos.north().east());
        result.add(pos.north().west());
        result.add(pos.south().east());
        result.add(pos.south().west());
        return result;
    }

    public static Collection<BlockPos> collectVeinMine(BlockPos pos, Level level, Predicate<BlockState> canHarvest, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        int blocks = 0;
        toVisit.add(pos);
        while (!toVisit.isEmpty() && blocks < maxBlocks) {
            BlockPos next = (BlockPos)toVisit.poll();
            boolean added = visited.add(next);
            if (!added) continue;
            toVisit.addAll(BlockCollectors.getNextBlocks(next, level, canHarvest));
            ++blocks;
        }
        return visited;
    }

    private static List<BlockPos> getNextBlocks(BlockPos pos, Level level, Predicate<BlockState> canHarvest) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(BlockCollectors.getAdjacentPositions(pos));
        result.add(pos.above());
        result.add(pos.below());
        result.addAll(BlockCollectors.getAdjacentPositions(pos.above()));
        result.addAll(BlockCollectors.getAdjacentPositions(pos.below()));
        return result.stream().filter(x -> canHarvest.test(level.getBlockState(x))).toList();
    }

    private static List<BlockPos> getAdjacentPositions(BlockPos pos) {
        return List.of(pos.north(), pos.north().east(), pos.east(), pos.south().east(), pos.south(), pos.south().west(), pos.west(), pos.north().west());
    }
}

