/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import com.mojang.datafixers.util.Pair;
import dev.willyelton.crystal_tools.ModRegistration;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalTorch;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalWallTorch;
import dev.willyelton.crystal_tools.common.levelable.tool.VeinMinerLevelableTool;
import dev.willyelton.crystal_tools.common.network.data.BlockStripPayload;
import dev.willyelton.crystal_tools.utils.BlockCollectors;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.ItemAbilities;

public class ToolUseUtils {
    public static InteractionResult useOnAxe(UseOnContext context, Levelable levelable) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState blockstate = level.getBlockState(blockpos);
        ItemStack stack = context.getItemInHand();
        int durability = stack.getMaxDamage() - stack.getDamageValue();
        if (durability <= 1) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
        Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false));
        Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false));
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.playSound((Entity)player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.playSound((Entity)player, blockpos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent((Entity)player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.playSound((Entity)player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent((Entity)player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, stack);
            }
            level.setBlock(blockpos, (BlockState)optional3.get(), 11);
            if (player != null) {
                stack.hurtAndBreak(1, (LivingEntity)player, context.getHand().asEquipmentSlot());
            }
            levelable.addExp(level, blockpos, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static <T extends VeinMinerLevelableTool> InteractionResult useOnAxeVeinStrip(UseOnContext context, T tool) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos blockPos = context.getClickedPos();
        BlockState initialState = level.getBlockState(blockPos);
        ItemStack stack = context.getItemInHand();
        Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
        if (levelable == null) {
            return InteractionResult.PASS;
        }
        InteractionResult result = ToolUseUtils.useOnAxe(context, levelable);
        if (result == InteractionResult.SUCCESS && (Integer)stack.getOrDefault(DataComponents.VEIN_MINER, (Object)0) > 0 && level.isClientSide() && RegisterKeyBindingsEvent.VEIN_MINE.isDown()) {
            Collection<BlockPos> blocksToStrip = BlockCollectors.collectVeinMine(blockPos, level, tool.getVeinMinerPredicate(initialState), tool.getMaxBlocks(stack));
            for (BlockPos pos : blocksToStrip) {
                BlockState blockState = level.getBlockState(pos);
                Optional<BlockState> optional = Optional.ofNullable(blockState.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
                if (!optional.isPresent()) continue;
                ToolUseUtils.stripBlock(level, stack, player, pos, context.getHand(), optional.get(), levelable);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new BlockStripPayload(pos, context.getHand(), optional.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return result;
    }

    public static void stripBlock(Level level, ItemStack stack, Player player, BlockPos blockPos, InteractionHand hand, BlockState newState, Levelable levelable) {
        if (stack.getMaxDamage() - stack.getDamageValue() == 0) {
            return;
        }
        level.setBlock(blockPos, newState, 11);
        if (player != null) {
            stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
        }
        levelable.addExp(level, blockPos, (LivingEntity)player);
    }

    public static InteractionResult useOnShovel(UseOnContext context, BlockPos blockpos) {
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos);
        if (ToolUtils.isBroken(stack)) {
            return InteractionResult.PASS;
        }
        Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
        if (levelable == null) {
            return InteractionResult.PASS;
        }
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        BlockState blockstate1 = blockstate.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.isEmptyBlock(blockpos.above())) {
            level.playSound((Entity)player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.getBlock() instanceof CampfireBlock && ((Boolean)blockstate.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            if (!level.isClientSide()) {
                level.levelEvent((Entity)((Player)null), 1009, blockpos, 0);
            }
            CampfireBlock.dowse((Entity)context.getPlayer(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!level.isClientSide()) {
                level.setBlock(blockpos, blockstate2, 11);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getHand().asEquipmentSlot());
                }
            }
            levelable.addExp(level, blockpos, (LivingEntity)context.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useOnShovel3x3(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue() && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false)).booleanValue()) {
            InteractionResult result = null;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    InteractionResult shovelResult = ToolUseUtils.useOnShovel(context, context.getClickedPos().offset(i, 0, j));
                    if (shovelResult.equals((Object)InteractionResult.PASS)) continue;
                    result = shovelResult;
                }
            }
            return result == null ? InteractionResult.PASS : result;
        }
        return ToolUseUtils.useOnShovel(context, context.getClickedPos());
    }

    public static InteractionResult useOnTorch(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (((Boolean)stack.getOrDefault(DataComponents.TORCH, (Object)false)).booleanValue()) {
            BlockState torchBlockState;
            Level level = context.getLevel();
            BlockPos position = context.getClickedPos();
            BlockState state = level.getBlockState(position);
            Direction direction = context.getClickedFace();
            position = position.relative(direction);
            Levelable levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess());
            if (levelable == null) {
                return InteractionResult.PASS;
            }
            if (direction.equals((Object)Direction.UP)) {
                torchBlockState = (BlockState)((CrystalTorch)((Object)ModRegistration.CRYSTAL_TORCH.get())).defaultBlockState().setValue((Property)CrystalTorch.DROP_ITEM, (Comparable)Boolean.valueOf(false));
            } else {
                if (direction.equals((Object)Direction.DOWN)) {
                    return InteractionResult.PASS;
                }
                torchBlockState = (BlockState)((BlockState)((CrystalWallTorch)((Object)ModRegistration.CRYSTAL_WALL_TORCH.get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)CrystalTorch.DROP_ITEM, (Comparable)Boolean.valueOf(false));
            }
            if (!level.getBlockState(position).isAir() || !state.isFaceSturdy((BlockGetter)level, position, direction)) {
                return InteractionResult.PASS;
            }
            level.setBlock(position, torchBlockState, 0);
            level.playSound((Entity)context.getPlayer(), position, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide() && context.getPlayer() != null) {
                stack.hurtAndBreak(10, (LivingEntity)context.getPlayer(), context.getHand().asEquipmentSlot());
            }
            levelable.addExp(level, context.getClickedPos(), (LivingEntity)context.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useOnHoe(UseOnContext context) {
        return ToolUseUtils.useOnHoe(context, context.getClickedPos());
    }

    public static InteractionResult useOnHoe(UseOnContext context, BlockPos blockPos) {
        Pair pair;
        ItemStack stack = context.getItemInHand();
        int durability = stack.getMaxDamage() - stack.getDamageValue();
        if (durability <= 1) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockPos).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, ToolUseUtils.changeIntoState(toolModifiedState, blockPos));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Levelable levelable;
            Player player = context.getPlayer();
            level.playSound((Entity)player, blockPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                consumer.accept(context);
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getHand().asEquipmentSlot());
                }
            }
            if ((levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) == null) {
                return InteractionResult.PASS;
            }
            levelable.addExp(level, blockPos, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useOnHoe3x3(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue() && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false)).booleanValue()) {
            InteractionResult result = null;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    InteractionResult hoeResult = ToolUseUtils.useOnHoe(context, context.getClickedPos().offset(i, 0, j));
                    if (hoeResult.equals((Object)InteractionResult.PASS)) continue;
                    result = hoeResult;
                }
            }
            return result == null ? InteractionResult.PASS : result;
        }
        return ToolUseUtils.useOnHoe(context);
    }

    private static Consumer<UseOnContext> changeIntoState(BlockState blockState, BlockPos blockPos) {
        return context -> {
            context.getLevel().setBlock(blockPos, blockState, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)blockState));
        };
    }
}

