/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.config.CrystalToolsServerConfig;
import dev.willyelton.crystal_tools.common.config.VanillaSkillTreeLevel;
import dev.willyelton.crystal_tools.common.datamap.DataMaps;
import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class ToolUtils {
    public static boolean isBroken(ItemStack stack) {
        int durability = stack.getItem().getMaxDamage(stack) - stack.getDamageValue();
        return durability <= 1;
    }

    public static boolean willBreak(ItemStack stack, int durabilityToUse) {
        return stack.getMaxDamage() - stack.getDamageValue() <= durabilityToUse;
    }

    public static boolean hasSkillTree(ItemStack stack) {
        ResourceKey key = stack.getItemHolder().getKey();
        if (key == null) {
            return false;
        }
        if (stack.getItemHolder().getData(DataMaps.SKILL_TREES) == null) {
            return false;
        }
        ResourceLocation location = key.location();
        if ("minecraft".equalsIgnoreCase(location.getNamespace())) {
            return switch ((VanillaSkillTreeLevel)((Object)CrystalToolsServerConfig.VANILLA_SKILL_TREES.get())) {
                default -> throw new MatchException(null, null);
                case VanillaSkillTreeLevel.ALL -> true;
                case VanillaSkillTreeLevel.NONE -> false;
                case VanillaSkillTreeLevel.NETHERITE -> location.getPath().contains("netherite");
                case VanillaSkillTreeLevel.DIAMOND_NETHERITE -> location.getPath().contains("netherite") || location.getPath().contains("diamond");
            };
        }
        return true;
    }

    public static int getNewCap(int currentCap, int levelIncrease) {
        return (int)Math.min((float)((double)currentCap * Math.pow((Double)CrystalToolsConfig.EXPERIENCE_MULTIPLIER.get(), levelIncrease)), (float)((Integer)CrystalToolsConfig.MAX_EXP.get()).intValue());
    }

    public static void resetPoints(ItemStack stack, Player player) {
        List contents;
        if (player instanceof ServerPlayer && (contents = (List)stack.get(DataComponents.BACKPACK_INVENTORY)) != null) {
            Level level = player.level();
            for (ItemContainerContents item : contents) {
                item.stream().forEach(toDrop -> level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), toDrop)));
            }
        }
        ItemStackUtils.removeAllComponents(stack);
        SkillPoints points = (SkillPoints)stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
        int skillPoints = (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
        stack.set(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
        stack.set(DataComponents.SKILL_POINTS, (Object)(skillPoints += points.getTotalPoints()));
    }

    public static boolean isValidEntity(LivingEntity entity) {
        return !entity.getType().is(CrystalToolsTags.ENTITY_BLACKLIST);
    }

    public static Optional<Holder.Reference<SkillData>> getSkillData(RegistryAccess registryAccess, ResourceLocation treeLocation) {
        if (registryAccess == null) {
            return Optional.empty();
        }
        Optional skillDataOptional = registryAccess.lookup(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS);
        return skillDataOptional.flatMap(skillData -> skillData.get(treeLocation));
    }

    public static List<ItemStack> getFilterItems(ItemStack stack) {
        ItemContainerContents filterContents = (ItemContainerContents)stack.get(DataComponents.FILTER_INVENTORY);
        if (filterContents == null) {
            return Collections.emptyList();
        }
        return filterContents.stream().filter(stack1 -> !stack1.isEmpty()).toList();
    }

    public static boolean matchesFilter(ItemStack stack, ItemStack toMatch, List<ItemStack> filter) {
        if ((Integer)stack.getOrDefault(DataComponents.FILTER_CAPACITY, (Object)0) == 0) {
            return true;
        }
        boolean whiteList = (Boolean)stack.getOrDefault(DataComponents.WHITELIST, (Object)true);
        for (ItemStack filterStack : filter) {
            if (!filterStack.is(toMatch.getItem())) continue;
            return whiteList;
        }
        return !whiteList;
    }
}

