/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TransferUtils {
    public static IndexModifier<ItemResource> playerIndexModifier(Inventory inventory) {
        return (index, resource, amount) -> {
            inventory.setItem(index, resource.toStack(amount));
            inventory.setChanged();
        };
    }

    public static void clear(ResourceHandler<ItemResource> handler) {
        try (Transaction tx = Transaction.open(null);){
            for (int i = 0; i < handler.size(); ++i) {
                ItemResource resource = (ItemResource)handler.getResource(i);
                if (resource.isEmpty()) continue;
                handler.extract(i, (Resource)resource, handler.getCapacityAsInt(i, (Resource)resource), (TransactionContext)tx);
            }
            tx.commit();
        }
    }

    public static IndexModifier<ItemResource> indexModifier(ResourceHandler<ItemResource> handler) {
        return (index, resource, amount) -> {
            try (Transaction tx = Transaction.open(null);){
                ItemResource invResource = (ItemResource)handler.getResource(index);
                if (!invResource.isEmpty()) {
                    handler.extract(index, (Resource)invResource, handler.getCapacityAsInt(index, (Resource)invResource), (TransactionContext)tx);
                }
                if (!resource.isEmpty()) {
                    handler.insert(index, resource, amount, (TransactionContext)tx);
                }
                tx.commit();
            }
        };
    }

    public static IndexModifier<ItemResource> itemstackIndexModifier(ItemStack stack) {
        return (index, resource, amount) -> {
            ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
            NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), 256), (Object)ItemStack.EMPTY);
            contents.copyInto(list);
            list.set(index, (Object)resource.toStack(amount));
            stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)list));
        };
    }

    public static List<ItemStack> extractAll(ResourceHandler<ItemResource> handler) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try (Transaction tx = Transaction.open(null);){
            for (int i = 0; i < handler.size(); ++i) {
                int extracted;
                ItemResource resource = (ItemResource)handler.getResource(i);
                if (resource.isEmpty() || (extracted = handler.extract(i, (Resource)resource, handler.getCapacityAsInt(i, (Resource)resource), (TransactionContext)tx)) <= 0) continue;
                items.add(resource.toStack(extracted));
            }
            tx.commit();
        }
        return items;
    }
}

