/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import net.minecraft.world.entity.player.Player;

public class XpUtils {
    public static long getXPForLevel(long level) {
        if (level <= 15L) {
            return level * level + 6L * level;
        }
        if (level <= 30L) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelForXp(int xp) {
        if (xp <= 352) {
            return (int)Math.ceil(Math.sqrt(xp + 9) - 3.0);
        }
        if (xp <= 1507) {
            return (int)Math.ceil(8.1 + Math.sqrt(0.4 * ((double)xp - 195.975)));
        }
        return (int)Math.ceil(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)xp - 752.9861111111111)));
    }

    public static long getPlayerTotalXp(Player player) {
        return XpUtils.getXPForLevel(player.experienceLevel) + (long)Math.floor(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static int getXpCost(int pointsToGain, int totalPoints) {
        int xpLevelCost = (Integer)CrystalToolsConfig.EXPERIENCE_PER_SKILL_LEVEL.get();
        int levelScaling = (Integer)CrystalToolsConfig.EXPERIENCE_LEVELING_SCALING.get();
        if (levelScaling > 0) {
            int pointsToSpend;
            int i;
            long totalCost = 0L;
            int pointsAtLowerLevelLeft = Math.min(levelScaling - totalPoints % levelScaling, pointsToGain);
            int pointCost1 = Math.min(totalPoints / levelScaling, 500);
            totalCost += (long)pointsAtLowerLevelLeft * XpUtils.getXPForLevel(xpLevelCost + pointCost1);
            int n = i = pointsAtLowerLevelLeft == 0 ? 0 : 1;
            for (int pointsLeft = pointsToGain - pointsAtLowerLevelLeft; pointsLeft > 0; pointsLeft -= pointsToSpend) {
                pointsToSpend = Math.min(levelScaling, pointsLeft);
                int pointCost = Math.min(totalPoints / levelScaling, 500);
                totalCost += (long)pointsToSpend * XpUtils.getXPForLevel(xpLevelCost + pointCost + i);
                ++i;
            }
            if (totalCost >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totalCost;
        }
        int totalCost = pointsToGain * xpLevelCost;
        if (totalCost < 0) {
            return Integer.MAX_VALUE;
        }
        return totalCost;
    }
}

