/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.CrystalBackpackScreen;
import dev.willyelton.crystal_tools.client.gui.SubScreenContainerScreen;
import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.common.network.data.BackpackScreenPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public abstract class BackpackSubScreen<T extends BaseContainerMenu, U extends Screen>
extends AbstractContainerScreen<T> {
    private final U returnScreen;

    public BackpackSubScreen(T menu, Inventory playerInventory, Component title, U returnScreen) {
        super(menu, playerInventory, title);
        this.returnScreen = returnScreen;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int row;
        int containerRows = this.getContainerRows();
        int contentRows = this.getRowsToDraw();
        this.drawTopBar(guiGraphics);
        for (row = 0; row < contentRows; ++row) {
            this.drawContentRow(guiGraphics, row);
        }
        for (row = 0; row < containerRows - contentRows; ++row) {
            this.drawEmptyRow(guiGraphics, row + contentRows);
        }
        this.drawPlayerInventory(guiGraphics, containerRows);
        this.drawBottomBar(guiGraphics, this.topPos + 17 + 18 * containerRows + 96 - 4);
    }

    public void onClose() {
        ((SubScreenContainerMenu)((Object)((BaseContainerMenu)this.menu))).closeSubScreen();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new BackpackScreenPayload(BackpackScreenPayload.BackpackAction.CLOSE_SUB_SCREEN), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.returnScreen != null) {
            this.minecraft.popGuiLayer();
            this.minecraft.setScreen(this.returnScreen);
        } else {
            super.onClose();
        }
    }

    protected void init() {
        int rowsToDraw = this.getContainerRows();
        this.inventoryLabelY = rowsToDraw * 18 + 18 + 2;
        this.imageHeight = 113 + rowsToDraw * 18;
        super.init();
    }

    public U getReturnScreen() {
        return this.returnScreen;
    }

    public int getContainerRows() {
        if (this.returnScreen == null) {
            return 3;
        }
        return ((SubScreenContainerScreen)this.getReturnScreen()).getDisplayRows();
    }

    protected void drawTopBar(GuiGraphics guiGraphics) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, 176, 17, 512, 512);
    }

    protected void drawEmptyRow(GuiGraphics guiGraphics, int rowIndex) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.leftPos, this.topPos + 17 + 18 * rowIndex, 0.0f, 8.0f, 176, 18, 512, 512);
    }

    protected void drawPlayerInventory(GuiGraphics guiGraphics, int rowIndex) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.leftPos, this.topPos + 17 + 18 * rowIndex, 0.0f, 125.0f, 176, 92, 512, 512);
    }

    protected void drawBottomBar(GuiGraphics guiGraphics, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, CrystalBackpackScreen.TEXTURE, this.leftPos, y, 0.0f, 217.0f, 176, 4, 512, 512);
    }

    protected abstract int getRowsToDraw();

    protected abstract void drawContentRow(GuiGraphics var1, int var2);

    public abstract Component getButtonName();

    public abstract SubScreenType getType();

    public abstract int getButtonTextureXOffset();
}

