/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.client.gui.BlockEntityUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.component.BlockEntityUpgradeButton;
import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.utils.IntegerUtils;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public abstract class BaseMenuUpgradeScreen<T extends LevelableContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final int UPGRADE_BUTTON_X = 155;
    protected static final int UPGRADE_BUTTON_Y = 6;
    protected static final int UPGRADE_BUTTON_WIDTH = 12;
    protected static final int UPGRADE_BUTTON_HEIGHT = 12;
    private final ResourceLocation skillLocation;
    private final float expLabelX;

    public BaseMenuUpgradeScreen(T menu, Inventory playerInventory, Component title, ResourceLocation skillLocation) {
        super(menu, playerInventory, title);
        this.skillLocation = skillLocation;
        this.expLabelX = this.inventoryLabelX + 112;
    }

    protected void init() {
        super.init();
        Optional<Holder.Reference<SkillData>> optionalSkillData = this.getSkillData();
        optionalSkillData.ifPresent(this::initUpgradeButton);
    }

    protected Optional<Holder.Reference<SkillData>> getSkillData() {
        Optional skillDataOptional;
        Level level = ((LevelableContainerMenu)this.getMenu()).getLevel();
        if (level != null && (skillDataOptional = level.registryAccess().lookup(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_BLOCKS)).isPresent()) {
            Registry skillDataRegistry = (Registry)skillDataOptional.get();
            return skillDataRegistry.get(this.skillLocation);
        }
        return Optional.empty();
    }

    protected void initUpgradeButton(Holder.Reference<SkillData> skillData) {
        this.addRenderableWidget((GuiEventListener)new BlockEntityUpgradeButton(155 + this.leftPos, 6 + this.topPos, 12, 12, (Component)Component.literal((String)"+"), pButton -> {
            Screen toOpen = this.upgradeButtonScreen(skillData);
            if (toOpen == null) {
                CrystalTools.LOGGER.warn("Couldn't open upgrade button, no skill tree defined");
            } else {
                ModGUIs.openScreen(toOpen);
            }
        }, (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)(((LevelableContainerMenu)this.menu).getSkillPoints() + " Point(s) Available"));
            guiGraphics.setTooltipForNextFrame(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, false));
    }

    protected Screen upgradeButtonScreen(Holder.Reference<SkillData> skillData) {
        return new BlockEntityUpgradeScreen((LevelableContainerMenu)this.menu, ((LevelableContainerMenu)this.menu).getPlayer(), (Screen)this, (SkillData)skillData.value(), (ResourceKey<SkillData>)skillData.key());
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        int xOffset = (IntegerUtils.getDigits(((LevelableContainerMenu)this.menu).getExp()) - 1) * 6 + (IntegerUtils.getDigits(((LevelableContainerMenu)this.menu).getExpCap()) - 2) * 6;
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Exp: %d/%d", ((LevelableContainerMenu)this.menu).getExp(), ((LevelableContainerMenu)this.menu).getExpCap())), (int)(this.expLabelX - (float)xOffset), this.inventoryLabelY, -12566464, false);
    }
}

