/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.config.CrystalToolsClientConfig;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.SkillButton;
import dev.willyelton.crystal_tools.client.gui.component.XpButton;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeOrSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NotNodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillItemRequirement;
import dev.willyelton.crystal_tools.common.network.data.PointsFromXpPayload;
import dev.willyelton.crystal_tools.common.network.data.RemoveItemPayload;
import dev.willyelton.crystal_tools.utils.Colors;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.ListUtils;
import dev.willyelton.crystal_tools.utils.XpUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public abstract class BaseUpgradeScreen
extends Screen {
    protected static final int Y_PADDING = 30;
    protected static final int X_SIZE = 100;
    protected static final int Y_SIZE = 20;
    protected static final int MIN_X_PADDING = 5;
    private static final ResourceLocation DEPENDENCY_LINE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/dependency_line.png");
    private static final float DEPENDENCY_LINE_WIDTH = 9.0f;
    private static final int DEPENDENCY_LINE_IMAGE_WIDTH = 252;
    private static final int DEPENDENCY_LINE_IMAGE_HEIGHT = 256;
    private static final int MAX_PER_TIER = 6;
    private static int ANIMATION_FRAME = 0;
    private static final int ANIMATION_FRAME_MIN = 0;
    private static int ANIMATION_COUNTER = 0;
    private static final int ANIMATION_COUNTER_MAX = 10;
    protected final Player player;
    protected SkillPoints points;
    protected final SkillData data;
    protected final ResourceKey<SkillData> key;
    private final HashMap<Integer, SkillButton> skillButtons = new HashMap();
    private int xOffset = 0;
    private int yOffset = 0;
    @Nullable
    private XpButton xpButton;
    @Nullable
    private Button resetButton;

    public BaseUpgradeScreen(Player player, Component title, SkillData data, ResourceKey<SkillData> key) {
        super(title);
        this.player = player;
        this.data = data;
        this.key = key;
    }

    protected void init() {
        if (this.points == null) {
            this.points = this.getPoints();
        }
        List<List<SkillDataNode>> tiers = this.data.getAllNodesByTier();
        int y = 30;
        for (List<SkillDataNode> tier : tiers) {
            if (tier.size() > 6) {
                for (List<SkillDataNode> subTier : ListUtils.partition(tier, 5)) {
                    this.addButtonsFromTier(subTier, y);
                    y += 50;
                }
                continue;
            }
            this.addButtonsFromTier(tier, y);
            y += 50;
        }
        this.initComponents();
        this.updateButtons();
    }

    protected void initComponents() {
        if ((Integer)CrystalToolsConfig.EXPERIENCE_PER_SKILL_LEVEL.get() > 0 && this.allowXpLevels()) {
            this.xpButton = (XpButton)this.addRenderableWidget((GuiEventListener)new XpButton(5, this.getXpButtonY(), 30, 20, pButton -> {
                int pointsToGain = this.getPointsToSpend(Integer.MAX_VALUE, BaseUpgradeScreen.hasShiftDown(), BaseUpgradeScreen.hasControlDown());
                int xpCost = XpUtils.getXpCost(pointsToGain, this.points.getTotalPoints() + this.getSkillPoints());
                if (XpUtils.getPlayerTotalXp(this.player) >= (long)xpCost) {
                    this.player.giveExperiencePoints(-xpCost);
                    this.changeClientSkillPoints(pointsToGain);
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new PointsFromXpPayload(pointsToGain, this instanceof UpgradeScreen), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.updateButtons();
                }
            }, (button, guiGraphics, mouseX, mouseY) -> {
                MutableComponent textComponent = Component.literal((String)String.format("Use Experience To Gain Skill Points (+%d Points)", this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown())));
                guiGraphics.setTooltipForNextFrame(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
            }, () -> XpUtils.getLevelForXp(XpUtils.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown()), this.points.getTotalPoints() + this.getSkillPoints()))));
        }
        boolean resetRequiresCrystal = (Boolean)CrystalToolsConfig.REQUIRE_CRYSTAL_FOR_RESET.get();
        Object text = "Reset Skill Points";
        if (resetRequiresCrystal) {
            text = (String)text + " (Requires 1 Crystal)";
        }
        Tooltip resetTooltip = Tooltip.create((Component)Component.literal((String)text));
        if (this.allowReset()) {
            this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), button -> {
                this.resetPoints(resetRequiresCrystal);
                if (resetRequiresCrystal) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new RemoveItemPayload(((Item)Registration.CRYSTAL.get()).getDefaultInstance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    InventoryUtils.removeItemFromInventory(this.player.getInventory(), ((Item)Registration.CRYSTAL.get()).getDefaultInstance());
                }
            }).bounds(this.width - 40 - 5, 15, 40, 20).tooltip(resetTooltip).build());
        }
    }

    protected boolean allowReset() {
        return true;
    }

    protected boolean allowXpLevels() {
        return true;
    }

    protected abstract int getXpButtonY();

    protected abstract void resetPoints(boolean var1);

    public abstract SkillPoints getPoints();

    protected abstract void changeClientSkillPoints(int var1);

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBlockBackground(guiGraphics, (String)CrystalToolsClientConfig.UPGRADE_SCREEN_BACKGROUND.get());
        this.drawDependencyLines(guiGraphics);
        guiGraphics.nextStratum();
        guiGraphics.drawString(this.font, "Skill Points: " + this.getSkillPoints(), 5, 5, -1);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (++ANIMATION_COUNTER > 10) {
            ANIMATION_COUNTER = 0;
            if (ANIMATION_FRAME < 0) {
                ANIMATION_FRAME = 11;
            }
            --ANIMATION_FRAME;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderTransparentBackground(guiGraphics);
    }

    protected abstract int getSkillPoints();

    public boolean isPauseScreen() {
        return false;
    }

    private void addButtonsFromTier(List<SkillDataNode> nodes, int y) {
        int paddingX;
        int size = nodes.size();
        int x = paddingX = Math.max((this.width - size * 100) / (size + 1), 5);
        for (SkillDataNode node : nodes) {
            this.addButtonFromNode(node, x, y);
            x += paddingX + 100;
        }
    }

    private void addButtonFromNode(SkillDataNode node, int x, int y) {
        this.addSkillButton(new SkillButton(x, y, 100, 20, (Component)Component.literal((String)node.getName()), button -> this.onSkillButtonPress(node, button), (button, guiGraphics, mouseX, mouseY) -> {
            FormattedText compositeComponent;
            Object text;
            if (node.getLimit() == 1) {
                text = node.getDescription();
            } else {
                int pointsToAdd = this.getPointsToSpend(Integer.MAX_VALUE, BaseUpgradeScreen.hasShiftDown(), BaseUpgradeScreen.hasControlDown());
                text = node.getLimit() == 0 ? String.format("%s\n%d Points", node.getDescription(), this.points.getPoints(node.getId())) : String.format("%s\n%d/%d Points", node.getDescription(), this.points.getPoints(node.getId()), node.getLimit());
                if (pointsToAdd > 1) {
                    text = (String)text + String.format("\n(+ %d Points)", pointsToAdd);
                }
            }
            Optional<SkillSubText> subText = Optional.ofNullable(node.getSkillSubText());
            MutableComponent textComponent = Component.literal((String)text);
            if (subText.isPresent()) {
                FormattedText subTextComponent = FormattedText.of((String)("\n" + subText.get().text()), (Style)Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)subText.get().color()).getOrThrow()));
                compositeComponent = FormattedText.composite((FormattedText[])new FormattedText[]{textComponent, subTextComponent});
            } else {
                compositeComponent = FormattedText.composite((FormattedText[])new FormattedText[]{textComponent});
            }
            guiGraphics.setTooltipForNextFrame(this.font, this.font.split(compositeComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, node, this.player, this.points));
    }

    protected void onSkillButtonPress(SkillDataNode node, Button button) {
        List<SkillDataRequirement> requirements = node.getRequirements();
        for (SkillDataRequirement requirement : requirements) {
            if (!((Boolean)CrystalToolsConfig.ENABLE_ITEM_REQUIREMENTS.get()).booleanValue() || requirement.getRequirementType() != RequirementType.ITEM) continue;
            SkillItemRequirement itemRequirement = (SkillItemRequirement)requirement;
            itemRequirement.getItems().forEach(item -> {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new RemoveItemPayload(item.getDefaultInstance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                InventoryUtils.removeItemFromInventory(this.player.getInventory(), item.getDefaultInstance());
            });
        }
        this.updateButtons();
    }

    private void addSkillButton(SkillButton button) {
        this.skillButtons.put(button.getDataNode().getId(), button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    void updateButtons() {
        int skillPoints = this.getSkillPoints();
        for (SkillButton button : this.skillButtons.values()) {
            SkillDataNode node = button.getDataNode();
            boolean bl = button.active = !button.isComplete && node.canLevel(this.points, this.player) && skillPoints > 0;
            if (this.points.getPoints(node.getId()) < node.getLimit() || node.getLimit() == 0) continue;
            button.setComplete();
        }
        if (this.xpButton != null) {
            this.xpButton.update(XpUtils.getXpCost(1, this.points.getTotalPoints() + this.getSkillPoints()), this.player);
        }
        if (this.resetButton != null) {
            this.resetButton.active = (Boolean)CrystalToolsConfig.REQUIRE_CRYSTAL_FOR_RESET.get() == false || this.player.getInventory().hasAnyOf(Set.of((Item)Registration.CRYSTAL.get()));
        }
    }

    private void drawDependencyLines(GuiGraphics guiGraphics) {
        for (SkillButton button : this.skillButtons.values()) {
            SkillDataNode node = button.getDataNode();
            block6: for (SkillDataRequirement requirement : node.getRequirements()) {
                SkillDataNodeRequirement skillDataNodeRequirement;
                if (!(requirement instanceof SkillDataNodeRequirement)) continue;
                SkillDataNodeRequirement nodeRequirement = (SkillDataNodeRequirement)((Object)requirement);
                int textureY = 0;
                boolean not = false;
                Objects.requireNonNull(nodeRequirement);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NotNodeSkillDataRequirement.class, NodeSkillDataRequirement.class, NodeOrSkillDataRequirement.class}, (Object)skillDataNodeRequirement, n)) {
                    case 0: {
                        NotNodeSkillDataRequirement n2 = (NotNodeSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 27;
                        not = true;
                        if (n2.getUnlessNodes().isEmpty()) break;
                        int unlessNode = n2.getUnlessNodes().getFirst();
                        if (!this.skillButtons.get((Object)Integer.valueOf((int)unlessNode)).isComplete) break;
                        continue block6;
                    }
                    case 1: {
                        NodeSkillDataRequirement ignored = (NodeSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 9;
                        break;
                    }
                    case 2: {
                        NodeOrSkillDataRequirement ignored = (NodeOrSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 18;
                        break;
                    }
                }
                List<Integer> nodes = nodeRequirement.getRequiredNodes();
                for (int j : nodes) {
                    boolean active;
                    if ((!this.skillButtons.containsKey(j) || !this.skillButtons.get(j).isHovered()) && !button.isHovered()) continue;
                    boolean bl = active = this.points.getPoints(this.skillButtons.get(j).getDataNode().getId()) > 0;
                    if (!active && !not) {
                        textureY = 0;
                    }
                    this.drawDependencyLine(guiGraphics, this.getButtonCenter(this.skillButtons.get(j)), this.getButtonCenter(button), textureY);
                }
            }
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset += (int)dragX;
        this.yOffset += (int)dragY;
        for (SkillButton skillButton : this.skillButtons.values()) {
            skillButton.xOffset = this.xOffset;
            skillButton.yOffset = this.yOffset;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (SkillButton skillButton : this.skillButtons.values()) {
            skillButton.yOffset += (int)scrollY * 10;
        }
        return true;
    }

    private void drawDependencyLine(GuiGraphics guiGraphics, int[] p1, int[] p2, int textureY) {
        this.drawDependencyLine(guiGraphics, p1[0], p1[1], p2[0], p2[1], textureY);
    }

    private void drawDependencyLine(final GuiGraphics guiGraphics, final int x1, final int y1, final int x2, final int y2, final int yImageStart) {
        final float yImageEnd = (float)yImageStart + 9.0f;
        final float length = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        float angle = (float)Math.atan2(x2 - x1, y2 - y1);
        float xOffset = 3.0f * (float)Math.cos(angle);
        float yOffset = 3.0f * (float)Math.sin(angle);
        final float x1F = (float)x1 - xOffset;
        final float y1F = (float)y1 + yOffset;
        final float x2F = (float)x1 + xOffset;
        final float y2F = (float)y1 - yOffset;
        final float x3F = (float)x2 + xOffset;
        final float y3F = (float)y2 - yOffset;
        final float x4F = (float)x2 - xOffset;
        final float y4F = (float)y2 + yOffset;
        guiGraphics.submitGuiElementRenderState(new GuiElementRenderState(){

            public void buildVertices(VertexConsumer consumer, float p_418216_) {
                consumer.addVertexWith2DPose(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x2F, y2F, p_418216_).setUv((float)ANIMATION_FRAME / 252.0f, (float)yImageStart / 256.0f).setColor(255, 255, 255, 255).addVertexWith2DPose(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x1F, y1F, p_418216_).setUv((float)ANIMATION_FRAME / 252.0f, yImageEnd / 256.0f).setColor(255, 255, 255, 255).addVertexWith2DPose(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x4F, y4F, p_418216_).setUv((length + (float)ANIMATION_FRAME) / 252.0f, yImageEnd / 256.0f).setColor(255, 255, 255, 255).addVertexWith2DPose(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x3F, y3F, p_418216_).setUv((length + (float)ANIMATION_FRAME) / 252.0f, (float)yImageStart / 256.0f).setColor(255, 255, 255, 255);
            }

            public RenderPipeline pipeline() {
                return RenderPipelines.GUI_TEXTURED;
            }

            public TextureSetup textureSetup() {
                TextureManager textureManager = Minecraft.getInstance().getTextureManager();
                return TextureSetup.singleTexture((GpuTextureView)textureManager.getTexture(DEPENDENCY_LINE_LOCATION).getTextureView());
            }

            @Nullable
            public ScreenRectangle scissorArea() {
                return guiGraphics.peekScissorStack();
            }

            @Nullable
            public ScreenRectangle bounds() {
                return new ScreenRectangle(x1, y1, x2, y2).transformMaxBounds((Matrix3x2f)guiGraphics.pose());
            }
        });
    }

    private int[] getButtonCenter(SkillButton button) {
        int x = button.getX() + button.xOffset + button.getWidth() / 2;
        int y = button.getY() + button.yOffset + button.getHeight() / 2;
        return new int[]{x, y};
    }

    public void renderBlockBackground(GuiGraphics guiGraphics, String block) {
        String[] split = block.split(":");
        ResourceLocation blockResource = split.length == 1 ? ResourceLocation.withDefaultNamespace((String)("textures/block/" + block + ".png")) : ResourceLocation.fromNamespaceAndPath((String)split[0], (String)("textures/block/" + split[1] + ".png"));
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, blockResource, 0, 0, 0.0f, 0.0f, this.width, this.height, 32, 32, Colors.fromRGB(255, 255, 255, (int)((Double)CrystalToolsClientConfig.BACKGROUND_OPACITY.get() * 255.0)));
    }

    protected int getPointsToSpend(int points, boolean shiftDown, boolean controlDown) {
        if (controlDown && shiftDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.CONTROL_POINT_SPEND.get() * (Integer)CrystalToolsClientConfig.SHIFT_POINT_SPEND.get());
        }
        if (controlDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.CONTROL_POINT_SPEND.get());
        }
        if (shiftDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.SHIFT_POINT_SPEND.get());
        }
        return 1;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.xpButton == null) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 340 || keyCode == 341 || keyCode == 344 || keyCode == 345) {
            this.xpButton.update(XpUtils.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown()), this.points.getTotalPoints() + this.getSkillPoints()), this.player);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.xpButton == null) {
            return super.keyReleased(keyCode, scanCode, modifiers);
        }
        if (keyCode == 340 || keyCode == 341 || keyCode == 344 || keyCode == 345) {
            this.xpButton.update(XpUtils.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown()), this.points.getTotalPoints() + this.getSkillPoints()), this.player);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

