/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.BackpackSubScreen;
import dev.willyelton.crystal_tools.client.gui.CompressConfigScreen;
import dev.willyelton.crystal_tools.client.gui.FilterConfigScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.ScrollableContainerScreen;
import dev.willyelton.crystal_tools.client.gui.SubScreenContainerScreen;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.backpack.BackpackScreenButton;
import dev.willyelton.crystal_tools.client.gui.component.backpack.CompressButton;
import dev.willyelton.crystal_tools.client.gui.component.backpack.SortButton;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalBackpackContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.network.data.OpenBackpackPayload;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CrystalBackpackScreen
extends ScrollableContainerScreen<CrystalBackpackContainerMenu>
implements SubScreenContainerScreen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_backpack.png");
    static final int TEXTURE_SIZE = 512;
    static final int INVENTORY_WIDTH = 176;
    static final int INVENTORY_HEIGHT = 96;
    static final int TOP_BAR_HEIGHT = 17;
    static final int ROW_HEIGHT = 18;
    private final CrystalBackpackContainerMenu container;
    private final Player player;

    public CrystalBackpackScreen(CrystalBackpackContainerMenu container, Inventory inventory, Component name) {
        super(container, inventory, name, 173, 17, 128);
        this.container = container;
        this.player = inventory.player;
        this.inventoryLabelX = 8;
    }

    private void setHeights() {
        int rowsToDraw = this.getDisplayRows();
        this.inventoryLabelY = rowsToDraw * 18 + 18 + 2;
        this.imageHeight = 113 + rowsToDraw * 18;
        this.imageWidth = 176;
        if (rowsToDraw > ((CrystalBackpackContainerMenu)this.menu).getRows()) {
            this.imageWidth += 18;
        }
        this.setScrollHeight(rowsToDraw * 18);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int rowsToDraw = this.getDisplayRows();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, 176, 17, 512, 512);
        for (int row = 0; row < rowsToDraw; ++row) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos + 17 + 18 * row, 0.0f, 222.0f, 176, 18, 512, 512);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos + 17 + 18 * rowsToDraw, 0.0f, 125.0f, 176, 96, 512, 512);
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }

    @Override
    public int getDisplayRows() {
        if (this.getMaxDisplayRows() <= 0) {
            return ((CrystalBackpackContainerMenu)this.menu).getRows();
        }
        return Math.min(((CrystalBackpackContainerMenu)this.menu).getRows(), this.getMaxDisplayRows());
    }

    @Override
    public int getMaxDisplayRows() {
        return (this.height - 17 - 96) / 18;
    }

    @Override
    public void resize(Minecraft minecraft, int width, int height) {
        this.onClose();
        super.resize(minecraft, width, height);
    }

    @Override
    protected void init() {
        this.setHeights();
        super.init();
        int actionButtonX = this.leftPos + 157;
        int screenButtonY = this.topPos + 17;
        if (((CrystalBackpackContainerMenu)this.menu).canSort()) {
            this.addRenderableWidget((GuiEventListener)new SortButton(actionButtonX, this.topPos + 4, this, this.container));
            actionButtonX -= 14;
        }
        if (((CrystalBackpackContainerMenu)this.menu).canCompress()) {
            this.addRenderableWidget((GuiEventListener)new CompressButton(actionButtonX, this.topPos + 4, this, this.container));
            actionButtonX -= 14;
        }
        this.addRenderableWidget((GuiEventListener)new BackpackScreenButton(this.leftPos - 21, screenButtonY, (Component)Component.literal((String)"Open Skill Tree"), button -> {
            this.onClose();
            Levelable levelable = (Levelable)this.container.getBackpackStack().getCapability(Capabilities.ITEM_SKILL, (Object)this.player.level().registryAccess());
            if (levelable != null) {
                ModGUIs.openScreen(new UpgradeScreen(((CrystalBackpackContainerMenu)this.menu).getSlotIndex(), ((CrystalBackpackContainerMenu)this.menu).getPlayer(), () -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new OpenBackpackPayload(((CrystalBackpackContainerMenu)this.menu).getSlotIndex()), (CustomPacketPayload[])new CustomPacketPayload[0]), levelable));
            }
        }, (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)"Open Skill Tree");
            guiGraphics.setTooltipForNextFrame(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, 40));
        List subScreenButtons = this.getSideButtons(this.leftPos - 21, screenButtonY += 21, this.width, (SubScreenContainerMenu)this.menu);
        subScreenButtons.forEach(x$0 -> {
            BackpackScreenButton cfr_ignored_0 = (BackpackScreenButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    @Override
    public List<BackpackSubScreen<?, ?>> getSubScreens() {
        ArrayList subScreens = new ArrayList();
        if (((CrystalBackpackContainerMenu)this.menu).getFilterRows() > 0) {
            subScreens.add(new FilterConfigScreen<CrystalBackpackContainerMenu, CrystalBackpackScreen>((CrystalBackpackContainerMenu)this.menu, ((CrystalBackpackContainerMenu)this.menu).getPlayerInventory(), this, true));
        }
        if (((CrystalBackpackContainerMenu)this.menu).canCompress()) {
            subScreens.add(new CompressConfigScreen((CrystalBackpackContainerMenu)this.menu, ((CrystalBackpackContainerMenu)this.menu).getPlayerInventory(), this));
        }
        return subScreens;
    }
}

