/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.client.gui.CrystalGeneratorScreen;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.inventory.container.AbstractGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.PortableGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PortableGeneratorScreen
extends CrystalGeneratorScreen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/portable_generator.png");
    private static final int DISABLED_SLOT_TEXTURE_X = 176;
    private static final int DISABLED_SLOT_TEXTURE_Y = 13;
    private static final int DISABLED_SLOT_TEXTURE_SIZE = 18;
    private static final int TOTAL_SLOTS = 27;
    private final int activeSlots;
    private final ItemStack generatorStack;

    public PortableGeneratorScreen(AbstractGeneratorContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.imageHeight = 218;
        this.inventoryLabelY = this.imageHeight - 94;
        if (container instanceof PortableGeneratorContainerMenu) {
            PortableGeneratorContainerMenu portableGeneratorContainerMenu = (PortableGeneratorContainerMenu)container;
            this.activeSlots = portableGeneratorContainerMenu.getActiveSlots();
            this.generatorStack = portableGeneratorContainerMenu.getGeneratorStack();
        } else {
            this.activeSlots = 0;
            this.generatorStack = ItemStack.EMPTY;
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.renderDisabledSlots(guiGraphics);
    }

    @Override
    protected Optional<Holder.Reference<SkillData>> getSkillData() {
        Optional skillDataOptional;
        Level level = ((AbstractGeneratorContainerMenu)this.getMenu()).getLevel();
        if (level != null && (skillDataOptional = level.registryAccess().lookup(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS)).isPresent()) {
            Registry skillDataRegistry = (Registry)skillDataOptional.get();
            return skillDataRegistry.get(CrystalTools.rl("portable_crystal_generator"));
        }
        return Optional.empty();
    }

    @Override
    protected ResourceLocation texture() {
        return TEXTURE;
    }

    @Override
    protected int fireY() {
        return 108;
    }

    @Override
    protected Screen upgradeButtonScreen(Holder.Reference<SkillData> skillData) {
        Player player = ((AbstractGeneratorContainerMenu)this.getMenu()).getPlayer();
        Levelable levelable = (Levelable)this.generatorStack.getCapability(Capabilities.ITEM_SKILL, (Object)player.level().registryAccess());
        if (levelable != null) {
            return new UpgradeScreen(this.generatorStack, ((AbstractGeneratorContainerMenu)this.menu).getPlayer(), levelable);
        }
        return null;
    }

    protected void renderDisabledSlots(GuiGraphics guiGraphics) {
        for (int i = this.activeSlots; i < 27; ++i) {
            int x = i % 9;
            int y = i / 9;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture(), this.leftPos + 8 + x * 18 - 1, this.topPos + 52 + y * 18 - 1, 176.0f, 13.0f, 18, 18, 256, 256);
        }
    }
}

