/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.common.inventory.container.ScrollableMenu;
import dev.willyelton.crystal_tools.common.network.data.ContainerRowsPayload;
import dev.willyelton.crystal_tools.common.network.data.ScrollPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public abstract class ScrollableContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/scroll_bar.png");
    protected static final int SCROLL_WIDTH = 14;
    protected static final int HANDLE_WIDTH = 12;
    protected static final int HANDLE_HEIGHT = 15;
    private final int scrollX;
    private final int scrollY;
    private int scrollHeight;
    private float scrollOffset;
    private boolean scrolling;
    private int currentRow;

    public ScrollableContainerScreen(T menu, Inventory playerInventory, Component title, int scrollX, int scrollY, int scrollHeight) {
        super(menu, playerInventory, title);
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.scrollHeight = scrollHeight;
        this.currentRow = 0;
    }

    protected void init() {
        super.init();
        ((ScrollableMenu)this.menu).setMaxRows(this.getMaxDisplayRows());
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ContainerRowsPayload(this.getMaxDisplayRows()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        int i = ((ScrollableMenu)this.menu).getRowIndexForScroll(this.scrollOffset);
        this.scrollOffset = ((ScrollableMenu)this.menu).getScrollForRowIndex(i);
        if (i != this.currentRow) {
            this.currentRow = i;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ScrollPayload(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.insideScrollbar(mouseX, mouseY)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.currentRow = Mth.clamp((int)(this.currentRow - (int)scrollY), (int)0, (int)(((ScrollableMenu)this.menu).getRows() - this.getMaxDisplayRows()));
        this.scrollOffset = ((ScrollableMenu)this.menu).getScrollForRowIndex(this.currentRow);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ScrollPayload(this.currentRow), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            int scrollTop = this.topPos + this.scrollY;
            int scrollBottom = scrollTop + this.scrollHeight;
            this.scrollOffset = ((float)mouseY - (float)scrollTop - 7.5f) / (float)(scrollBottom - scrollTop - 15);
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            int i = ((ScrollableMenu)this.menu).getRowIndexForScroll(this.scrollOffset);
            if (i != this.currentRow) {
                this.currentRow = i;
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new ScrollPayload(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        if (this.canScroll()) {
            int heightDrawn;
            int scrollXActual = this.leftPos + this.scrollX;
            int scrollYActual = this.topPos + this.scrollY;
            int scrollYEnd = scrollYActual + this.scrollHeight;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual, this.topPos, 0.0f, 0.0f, 21, this.scrollY, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual, scrollYActual, 21.0f, 0.0f, 21, 1, 256, 256);
            for (heightDrawn = 1; heightDrawn < this.scrollHeight - 254; heightDrawn += 254) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual, scrollYActual + heightDrawn, 21.0f, 1.0f, 21, 254, 256, 256);
            }
            int remainingHeight = this.scrollHeight - heightDrawn;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual, scrollYActual + heightDrawn, 21.0f, (float)(256 - remainingHeight), 21, remainingHeight, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual, scrollYActual + this.scrollHeight, 0.0f, 251.0f, 21, 5, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, scrollXActual + 1, scrollYActual + 1 + (int)((float)(scrollYEnd - scrollYActual - 17) * this.scrollOffset), 42.0f, 0.0f, 12, 15, 256, 256);
        }
    }

    public void setScrollHeight(int scrollHeight) {
        this.scrollHeight = scrollHeight;
    }

    public abstract int getMaxDisplayRows();

    protected boolean canScroll() {
        return ((ScrollableMenu)this.menu).canScroll();
    }

    private boolean insideScrollbar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + this.scrollX) && mouseX <= (double)(this.leftPos + this.scrollX + 14) && mouseY >= (double)(this.topPos + this.scrollY) && mouseY <= (double)(this.topPos + this.scrollY + this.scrollHeight);
    }
}

