/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.gui.BaseUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.SkillButton;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.capability.LevelableStack;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.network.data.ResetSkillsPayload;
import dev.willyelton.crystal_tools.common.network.data.ToolHealPayload;
import dev.willyelton.crystal_tools.common.network.data.ToolSkillPayload;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Set;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.Nullable;

public class UpgradeScreen
extends BaseUpgradeScreen {
    @Nullable
    private Button healButton;
    private final ItemStack stack;
    private final Runnable onClose;
    private final Levelable levelable;
    private int slotIndex = -1;

    public UpgradeScreen(ItemStack itemStack, Player player, Levelable levelable) {
        this(itemStack, player, null, levelable);
    }

    public UpgradeScreen(int slotIndex, Player player, Runnable onClose, Levelable levelable) {
        this(CrystalBackpack.getBackpackFromSlotIndex(player, slotIndex), player, onClose, levelable);
        this.slotIndex = slotIndex;
    }

    public UpgradeScreen(ItemStack itemStack, Player player, Runnable onClose, Levelable levelable) {
        super(player, (Component)Component.literal((String)"Upgrade Screen"), levelable.getSkillTree(), levelable.getKey());
        this.stack = itemStack;
        this.onClose = onClose;
        this.levelable = levelable;
    }

    @Override
    protected void initComponents() {
        LevelableStack levelableStack;
        super.initComponents();
        Levelable levelable = this.levelable;
        if (levelable instanceof LevelableStack && !(levelableStack = (LevelableStack)levelable).allowRepair()) {
            return;
        }
        this.healButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Heal"), button -> {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)ToolHealPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, -1);
            this.updateButtons();
            button.active = false;
        }).bounds(5, 15, 30, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Uses a skill point to fully repair this tool"))).build());
    }

    @Override
    protected void resetPoints(boolean crystalRequired) {
        if (!crystalRequired || this.player.getInventory().hasAnyOf(Set.of((Item)Registration.CRYSTAL.get()))) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)ResetSkillsPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            ToolUtils.resetPoints(this.stack);
        }
        this.onClose();
    }

    @Override
    public SkillPoints getPoints() {
        return ((SkillPoints)this.stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).copy();
    }

    @Override
    protected int getSkillPoints() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        int skillPoints = this.getSkillPoints();
        if (this.healButton != null) {
            this.healButton.active = skillPoints > 0 && this.stack.isDamaged();
        }
    }

    @Override
    protected void onSkillButtonPress(SkillDataNode node, Button button) {
        int skillPoints = this.getSkillPoints();
        boolean shift = UpgradeScreen.hasShiftDown();
        boolean control = UpgradeScreen.hasControlDown();
        if (skillPoints > 0) {
            int maxSpend;
            int pointsToSpend = 1;
            if ((node.getLimit() == 0 || node.getLimit() > 1) && (pointsToSpend = this.getPointsToSpend(skillPoints, shift, control)) > (maxSpend = node.getLimit() - this.points.getPoints(node.getId())) && node.getLimit() > 1) {
                pointsToSpend = maxSpend;
            }
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ToolSkillPayload(node.getId(), (ResourceKey<SkillData>)this.key, pointsToSpend), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.points.addPoints(node.getId(), pointsToSpend);
            DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, -pointsToSpend);
            if (this.points.getPoints(node.getId()) >= node.getLimit() && node.getLimit() != 0) {
                ((SkillButton)button).setComplete();
            }
        }
        super.onSkillButtonPress(node, button);
    }

    @Override
    protected void changeClientSkillPoints(int change) {
        DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, change);
    }

    @Override
    protected int getXpButtonY() {
        return 35;
    }

    public void onClose() {
        super.onClose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    protected boolean allowReset() {
        return this.levelable.allowReset();
    }

    @Override
    protected boolean allowXpLevels() {
        return this.levelable.allowXpLevels();
    }
}

