/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.joml.Vector3f;

public class CrystalShieldRenderer
implements SpecialModelRenderer<DataComponentMap> {
    private static final Material SHIELD_MATERIAL = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"entity/crystal_shield"));
    private final ShieldModel shieldModel;

    public CrystalShieldRenderer(ShieldModel shieldModel) {
        this.shieldModel = shieldModel;
    }

    @Nullable
    public DataComponentMap extractArgument(ItemStack stack) {
        return stack.immutableComponents();
    }

    public void render(DataComponentMap components, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean withGlint) {
        BannerPatternLayers bannerpatternlayers = components != null ? (BannerPatternLayers)components.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyecolor = components != null ? (DyeColor)components.get(DataComponents.BASE_COLOR) : null;
        boolean hasBanner = !bannerpatternlayers.layers().isEmpty() || dyecolor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = SHIELD_MATERIAL;
        VertexConsumer vertexconsumer = material.sprite().wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)this.shieldModel.renderType(material.atlasLocation()), (boolean)true, (boolean)withGlint));
        this.shieldModel.handle().render(poseStack, vertexconsumer, packedLight, packedOverlay);
        if (hasBanner) {
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (int)packedOverlay, (ModelPart)this.shieldModel.plate(), (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyecolor, DyeColor.WHITE), (BannerPatternLayers)bannerpatternlayers, (boolean)withGlint, (boolean)false);
        } else {
            this.shieldModel.plate().render(poseStack, vertexconsumer, packedLight, packedOverlay);
        }
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> vectors) {
        PoseStack posestack = new PoseStack();
        posestack.scale(1.0f, -1.0f, -1.0f);
        this.shieldModel.root().getExtentsForGui(posestack, vectors);
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet p_387269_) {
            return new CrystalShieldRenderer(new ShieldModel(p_387269_.bakeLayer(ModelLayers.SHIELD)));
        }
    }
}

