/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public class CrystalTridentSpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/entity/crystal_trident.png");
    private final TridentModel crystalTridentModel;

    public CrystalTridentSpecialRenderer(TridentModel crystalTridentModel) {
        this.crystalTridentModel = crystalTridentModel;
    }

    public void render(ItemDisplayContext context, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean glint) {
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)this.crystalTridentModel.renderType(TEXTURE), (boolean)false, (boolean)glint);
        this.crystalTridentModel.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> vectors) {
        PoseStack posestack = new PoseStack();
        posestack.scale(1.0f, -1.0f, -1.0f);
        this.crystalTridentModel.root().getExtentsForGui(posestack, vectors);
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<SpecialModelRenderer.Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        public MapCodec<SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet p_386553_) {
            return new CrystalTridentSpecialRenderer(new TridentModel(p_386553_.bakeLayer(ModelLayers.TRIDENT)));
        }
    }
}

