/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalPedestalBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.PedestalClientData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class CrystalPedestalBlockEntityRenderer
implements BlockEntityRenderer<CrystalPedestalBlockEntity> {
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();
    private final ItemClusterRenderState renderState = new ItemClusterRenderState();

    public CrystalPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(CrystalPedestalBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        ItemStack itemstack;
        Level level = blockEntity.getLevel();
        if (level != null && (itemstack = blockEntity.getStack()) != null && !itemstack.isEmpty()) {
            PedestalClientData clientData = blockEntity.getClientData();
            this.itemModelResolver.updateForTopItem(this.renderState.item, itemstack, ItemDisplayContext.GROUND, level, null, 0);
            this.renderState.count = ItemClusterRenderState.getRenderedAmount((int)itemstack.getCount());
            this.renderState.seed = ItemClusterRenderState.getSeedForItemStack((ItemStack)itemstack);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.rotateAround((Quaternionfc)((Direction)blockEntity.getBlockState().getValue(CrystalPedestalBlock.FACING)).getRotation(), 0.0f, 0.0f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.rotLerp((float)partialTick, (float)clientData.previousRot(), (float)clientData.currentRot())));
            poseStack.translate(0.0f, Mth.lerp((float)partialTick, (float)clientData.previousHeight(), (float)clientData.currentHeight()), 0.0f);
            ItemEntityRenderer.renderMultipleFromCount((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (ItemClusterRenderState)this.renderState, (RandomSource)this.random);
            poseStack.popPose();
        }
    }
}

