/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.willyelton.crystal_tools.client.renderer.QuarryCubeRenderer;
import dev.willyelton.crystal_tools.client.renderer.QuarryLaserRenderer;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalQuarryBlockEntity;
import dev.willyelton.crystal_tools.utils.Colors;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CrystalQuarryBlockEntityRenderer
implements BlockEntityRenderer<CrystalQuarryBlockEntity> {
    private final QuarryCubeRenderer cubeRenderer;

    public CrystalQuarryBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.cubeRenderer = new QuarryCubeRenderer(context.bakeLayer(QuarryCubeRenderer.LOCATION));
    }

    public void render(CrystalQuarryBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        BlockPos miningAt = blockEntity.getMiningAt();
        if (miningAt != null) {
            BlockPos quarryPos = blockEntity.getBlockPos();
            this.cubeRenderer.render((int)blockEntity.getLevel().getGameTime(), partialTick, poseStack, bufferSource, packedLight, blockEntity.getCenterX() - (float)quarryPos.getX(), blockEntity.getCenterY() - (float)quarryPos.getY(), blockEntity.getCenterZ() - (float)quarryPos.getZ());
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 view = camera.getPosition();
            int color = Colors.fromRGB(48, 231, 237, 255);
            int miningLaserColor = Colors.fromRGB(0, 144, 180, 255);
            poseStack.pushPose();
            poseStack.translate((double)(-blockEntity.getBlockPos().getX()) + view.x, (double)(-blockEntity.getBlockPos().getY()) + view.y, (double)(-blockEntity.getBlockPos().getZ()) + view.z);
            float centerX = blockEntity.getCenterX();
            float centerY = blockEntity.getCenterY();
            float centerZ = blockEntity.getCenterZ();
            QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), centerX, centerY, centerZ, blockEntity.getMiningAt(), miningLaserColor);
            List<BlockPos> corners = blockEntity.getStabilizerPositions();
            if (!corners.isEmpty()) {
                QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), corners.get(0), corners.get(1), color);
                QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), corners.get(1), corners.get(2), color);
                QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), corners.get(2), corners.get(3), color);
                QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), corners.get(3), corners.get(0), color);
            }
            for (BlockPos corner : corners) {
                QuarryLaserRenderer.renderLaser(bufferSource, poseStack, camera, partialTick, blockEntity.getLevel(), corner, centerX, centerY, centerZ, color);
            }
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(CrystalQuarryBlockEntity blockEntity) {
        return blockEntity.getAABB() == null ? AABB.INFINITE : blockEntity.getAABB();
    }

    public boolean shouldRender(CrystalQuarryBlockEntity blockEntity, Vec3 cameraPos) {
        return !blockEntity.isFinished();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }
}

