/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AddPointsBlockCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder addPointsCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add_points_block").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(commandContext -> AddPointsBlockCommand.addPointsToBlock((CommandContext<CommandSourceStack>)commandContext, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"points"), BlockPosArgument.getLoadedBlockPos((CommandContext)commandContext, (String)"pos")))));
        dispatcher.register(addPointsCommand);
    }

    static int addPointsToBlock(CommandContext<CommandSourceStack> commandContext, int points, BlockPos pos) {
        ServerLevel level = ((CommandSourceStack)commandContext.getSource()).getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LevelableBlockEntity) {
            LevelableBlockEntity levelableBlockEntity = (LevelableBlockEntity)blockEntity;
            levelableBlockEntity.addSkillPoints(points);
        }
        return 1;
    }
}

