/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.crafting.CrystalToolsRecipe;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystalElytraRecipe
extends CrystalToolsRecipe {
    public CrystalElytraRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        if (container.size() < 2) {
            return false;
        }
        boolean foundElytra = false;
        boolean foundChestplate = false;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack itemStack = container.getItem(i);
            if (itemStack.is((Item)Registration.CRYSTAL_CHESTPLATE.get())) {
                if (foundChestplate) {
                    return false;
                }
                foundChestplate = true;
                continue;
            }
            if (itemStack.is(Items.ELYTRA)) {
                if (foundElytra) {
                    return false;
                }
                foundElytra = true;
                continue;
            }
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return foundChestplate && foundElytra;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        ItemStack stack = new ItemStack((ItemLike)Registration.CRYSTAL_ELYTRA.get());
        List<ItemStack> items = this.getItems(container);
        ItemStack elytraItem = items.get(0);
        ItemStack crystalChestPlateItem = items.get(1);
        if (crystalChestPlateItem.isEmpty()) {
            return crystalChestPlateItem;
        }
        int enchantmentPoints = EnchantmentUtils.pointsFromEnchantments(elytraItem);
        int totalPoints = this.getPoints(stack) + enchantmentPoints;
        stack.set(DataComponents.SKILL_POINTS, (Object)totalPoints);
        stack.set(DataComponents.SKILL_EXPERIENCE, (Object)((Integer)crystalChestPlateItem.getOrDefault(DataComponents.SKILL_EXPERIENCE, (Object)0)));
        this.increaseLevelCap(stack, registryAccess, totalPoints);
        return stack;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)Registration.CRYSTAL_ELYTRA_RECIPE.get();
    }

    private List<ItemStack> getItems(CraftingInput container) {
        ItemStack elytraItem = ItemStack.EMPTY;
        ItemStack crystalChestPlateItem = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack itemStack = container.getItem(i);
            if (itemStack.is((Item)Registration.CRYSTAL_CHESTPLATE.get())) {
                crystalChestPlateItem = itemStack;
                continue;
            }
            if (!itemStack.is(Items.ELYTRA)) continue;
            elytraItem = itemStack;
        }
        return List.of(elytraItem, crystalChestPlateItem);
    }

    @Override
    public List<ItemStack> getInputs() {
        return List.of(new ItemStack((ItemLike)Registration.CRYSTAL_CHESTPLATE.get()), new ItemStack((ItemLike)Items.ELYTRA));
    }

    @Override
    public ItemStack getOutput() {
        return new ItemStack((ItemLike)Registration.CRYSTAL_ELYTRA.get());
    }
}

