/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.crafting;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public abstract class CrystalToolsRecipe
extends CustomRecipe {
    public CrystalToolsRecipe(CraftingBookCategory category) {
        super(category);
    }

    public abstract List<ItemStack> getInputs();

    public abstract ItemStack getOutput();

    protected int getPoints(ItemStack stack) {
        SkillPoints points = (SkillPoints)stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints());
        return points.getTotalPoints() + (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create(this.getIngredients());
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.getIngredients().stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.getOutput()), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    protected List<Ingredient> getIngredients() {
        return this.getInputs().stream().map(ItemStack::getItem).map(Ingredient::of).toList();
    }

    protected void increaseLevelCap(ItemStack stack, HolderLookup.Provider provider, int points) {
        RegistryAccess registryAccess;
        Levelable levelable;
        if (provider instanceof RegistryAccess && (levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)(registryAccess = (RegistryAccess)provider))) != null) {
            levelable.increaseExpCap(points);
            return;
        }
        int newCap = ToolUtils.getNewCap((Integer)CrystalToolsConfig.BASE_EXPERIENCE_CAP.get(), points);
        stack.set(DataComponents.EXPERIENCE_CAP, (Object)newCap);
    }
}

